/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.common.container;

import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import tfcastikorcarts.common.container.slot.FilteredSlot;

public class DynamicGridContainer
extends AbstractContainerMenu {
    public final int width;
    public final int height;
    public final Container container;
    public final TagKey<Item> whitelistTag;
    public final TagKey<Item> blacklistTag;
    public static final int SLOT_SIZE = 18;
    public static final int MARGIN = 7;
    public static final int PLAYER_SLOTS_WIDTH = 162;

    public DynamicGridContainer(MenuType<?> type, int windowId, Inventory playerInv, Container container, int width, int height, TagKey<Item> whitelistTag, TagKey<Item> blacklistTag) {
        super(type, windowId);
        this.width = width;
        this.height = height;
        this.container = container;
        this.whitelistTag = whitelistTag;
        this.blacklistTag = blacklistTag;
        container.startOpen(playerInv.player);
        this.init(playerInv);
    }

    public static DynamicGridContainer create(MenuType<?> type, int windowId, Inventory playerInv, int width, int height, TagKey<Item> whitelistTag, TagKey<Item> blacklistTag) {
        return DynamicGridContainer.create(type, windowId, playerInv, (Container)new SimpleContainer(width * height), width, height, whitelistTag, blacklistTag);
    }

    public static DynamicGridContainer create(MenuType<?> type, int windowId, Inventory playerInv, Container container, int width, int height, TagKey<Item> whitelistTag, TagKey<Item> blacklistTag) {
        return new DynamicGridContainer(type, windowId, playerInv, container, width, height, whitelistTag, blacklistTag);
    }

    public DynamicGridContainer init(Inventory playerInv) {
        int x;
        int imageWidth = 14 + Math.max(this.width * 18, 162);
        int gridStartX = (imageWidth - this.width * 18) / 2;
        int playerStartX = (imageWidth - 162) / 2;
        int slotIndex = 0;
        for (int y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                this.addSlot(new FilteredSlot(this.container, slotIndex++, gridStartX + x * 18, 18 + y * 18, this.whitelistTag, this.blacklistTag));
            }
        }
        int invY = 18 + this.height * 18 + 12;
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.addSlot(new Slot((Container)playerInv, x2 + y * 9 + 9, playerStartX + x2 * 18, invY + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)playerInv, x, playerStartX + x * 18, invY + 58));
        }
        return this;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot instanceof FilteredSlot) {
            ItemStack item;
            FilteredSlot filteredSlot = (FilteredSlot)slot;
            if (slot.hasItem() && !filteredSlot.mayPlace(item = slot.getItem())) {
                return ItemStack.EMPTY;
            }
        }
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            int gridSize = this.width * this.height;
            if (index < gridSize ? !this.moveItemStackTo(slotStack, gridSize, this.slots.size(), true) : !this.moveItemStackTo(slotStack, 0, gridSize, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return stack;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getSize() {
        return this.width * this.height;
    }

    public Container getContainer() {
        return this.container;
    }

    public TagKey<Item> getWhitelistTag() {
        return this.whitelistTag;
    }

    public TagKey<Item> getBlacklistTag() {
        return this.blacklistTag;
    }
}

