/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.common.entities.carts;

import com.jusipat.astikorcartsredux.entity.AbstractDrawnEntity;
import java.util.ArrayList;
import net.dries007.tfc.common.effect.TFCEffects;
import net.dries007.tfc.common.player.IPlayerInfo;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.WoodType;
import tfcastikorcarts.common.CartType;
import tfcastikorcarts.config.TFCAstikorCartsConfig;
import tfcastikorcarts.util.AstikorHelpers;
import tfcregistryapi.util.WoodRegistryHelper;

public abstract class TFCAbstractDrawnEntity
extends AbstractDrawnEntity {
    public static final EntityDataAccessor<String> WOOD_TYPE = SynchedEntityData.defineId(TFCAbstractDrawnEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public final Item drop;
    public CartType cartType;
    public RegistryWood wood;
    public boolean affectedByCargo;

    public TFCAbstractDrawnEntity(EntityType<? extends Entity> entityTypeIn, Level level, CartType cartType, RegistryWood wood) {
        super(entityTypeIn, level);
        this.drop = cartType.getItem(wood);
        this.cartType = cartType;
        this.wood = wood;
        this.blocksBuilding = true;
        this.affectedByCargo = true;
        this.initWheels();
    }

    public boolean affectedByCargo() {
        return this.affectedByCargo;
    }

    public CartType getCartType() {
        return this.cartType;
    }

    public RegistryWood getWood() {
        return this.wood;
    }

    public Item getCartItem() {
        return this.drop;
    }

    public void pulledTick() {
        Entity entity;
        super.pulledTick();
        if (this.affectedByCargo() && (entity = this.getPulling()) instanceof Player) {
            Player player = (Player)entity;
            IPlayerInfo playerInfo = IPlayerInfo.get((Player)player);
            double passengerWeight = Math.max((double)this.countOverburdened() * 0.01, 1.0);
            double healthFactor = TFCAstikorCartsConfig.COMMON.toggleFoodSpeed.get() != false ? (double)(playerInfo.nutrition().getAverageNutrition() * (playerInfo.getThirst() / 100.0f) * (float)(player.getFoodData().getFoodLevel() / 20)) : 1.0;
            double speedFactor = 0.25 + healthFactor * 0.75;
            player.setDeltaMovement(player.getDeltaMovement().multiply(speedFactor, 1.0, speedFactor));
            if (passengerWeight > TFCAstikorCartsConfig.COMMON.pinnedThreshold.get()) {
                player.addEffect(new MobEffectInstance((Holder)TFCEffects.PINNED.holder(), 25, 0, false, false));
            } else if (passengerWeight > TFCAstikorCartsConfig.COMMON.overburdenedThreshold.get()) {
                player.addEffect(Helpers.getOverburdened((boolean)false));
            } else if (passengerWeight > TFCAstikorCartsConfig.COMMON.exhaustedThreshold.get()) {
                player.addEffect(Helpers.getExhausted((boolean)false));
            }
        }
    }

    public float countOverburdened() {
        float weight = 1.0f;
        ArrayList passengers = new ArrayList(this.getPassengers());
        passengers.remove(this.getControllingPassenger());
        for (Entity passenger : passengers) {
            weight = (float)((double)weight + AstikorHelpers.getEstimatedMassKg(passenger.getBoundingBox()));
        }
        return weight;
    }

    public void setTFCWoodType(RegistryWood wood) {
        this.entityData.set(WOOD_TYPE, (Object)wood.getSerializedName());
        this.wood = wood;
    }

    public RegistryWood getTFCWoodType() {
        return this.wood;
    }

    public WoodType getWoodType() {
        return this.wood.getVanillaWoodType();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(WOOD_TYPE, (Object)"oak");
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setTFCWoodType(WoodRegistryHelper.getWoodValue((String)compound.getString("WoodType")));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("WoodType", this.getTFCWoodType().getSerializedName());
    }
}

