/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.common.entities.carts;

import com.jusipat.astikorcartsredux.util.NCInventory;
import net.dries007.tfc.common.component.size.IItemSize;
import net.dries007.tfc.common.component.size.ItemSizeManager;
import net.dries007.tfc.common.effect.TFCEffects;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tfcastikorcarts.common.CartType;
import tfcastikorcarts.common.entities.carts.TFCAbstractDrawnEntity;
import tfcastikorcarts.config.TFCAstikorCartsConfig;
import tfcastikorcarts.util.AstikorHelpers;

public abstract class TFCAbstractDrawnInventoryEntity
extends TFCAbstractDrawnEntity
implements HasCustomInventoryScreen,
ContainerEntity {
    public NCInventory itemStacks;
    public final int containerSize;
    @Nullable
    public ResourceKey<LootTable> lootTable;
    public long lootTableSeed;

    public TFCAbstractDrawnInventoryEntity(EntityType<? extends Entity> entityType, Level level, CartType cartType, RegistryWood wood, int containerSize) {
        super(entityType, level, cartType, wood);
        this.containerSize = containerSize;
        this.itemStacks = NCInventory.withSize((int)containerSize, (ItemStack)ItemStack.EMPTY);
        this.itemStacks.setOnContentsChanged(this::onContentsChanged);
    }

    public boolean stillValid(Player player) {
        return this.isChestVehicleStillValid(player);
    }

    @Override
    public void pulledTick() {
        Entity entity;
        super.pulledTick();
        if (this.affectedByCargo() && (entity = this.getPulling()) instanceof Player) {
            Player player = (Player)entity;
            double cargoMassKg = Math.max(this.countOverburdenedCargo() * 0.01, 1.0);
            if (cargoMassKg > TFCAstikorCartsConfig.COMMON.pinnedThreshold.get()) {
                player.addEffect(new MobEffectInstance((Holder)TFCEffects.PINNED.holder(), 25, 0, false, false));
            } else if (cargoMassKg > TFCAstikorCartsConfig.COMMON.overburdenedThreshold.get()) {
                player.addEffect(Helpers.getOverburdened((boolean)false));
            } else if (cargoMassKg > TFCAstikorCartsConfig.COMMON.exhaustedThreshold.get()) {
                player.addEffect(Helpers.getExhausted((boolean)false));
            }
        }
    }

    public double countOverburdenedCargo() {
        double count = 1.0;
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            IItemSize item = ItemSizeManager.get((ItemStack)stack);
            count += AstikorHelpers.getEstimatedMassKg(stack, item.getSize(stack), item.getWeight(stack));
        }
        return count;
    }

    public void onDestroyedAndDoDrops(DamageSource source) {
        this.chestVehicleDestroyed(source, this.level(), (Entity)this);
    }

    public void remove(Entity.RemovalReason removalReason) {
        if (!this.level().isClientSide && removalReason.shouldDestroy()) {
            Containers.dropContents((Level)this.level(), (Entity)this, (Container)this);
        }
        super.remove(removalReason);
    }

    public abstract InteractionResult onInteractNotOpen(Player var1, InteractionHand var2);

    public boolean canInteractNotOpen() {
        return true;
    }

    @NotNull
    public InteractionResult interact(Player player, InteractionHand interactionHand) {
        if (this.canInteractNotOpen() && this.canAddPassenger((Entity)player) && !player.isSecondaryUseActive()) {
            return this.onInteractNotOpen(player, interactionHand);
        }
        InteractionResult interactionResult = this.interactWithContainerVehicle(player);
        if (interactionResult.consumesAction()) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)player);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return interactionResult;
    }

    public void openCustomInventoryScreen(Player player) {
        player.openMenu((MenuProvider)this);
        if (!player.level().isClientSide) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)player);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
    }

    public void clearContent() {
        this.clearChestVehicleContent();
    }

    public int getContainerSize() {
        return this.containerSize;
    }

    @NotNull
    public ItemStack getItem(int i) {
        return this.getChestVehicleItem(i);
    }

    @NotNull
    public ItemStack removeItem(int i, int j) {
        return this.removeChestVehicleItem(i, j);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int i) {
        return this.removeChestVehicleItemNoUpdate(i);
    }

    public void setItem(int i, ItemStack itemStack) {
        this.setChestVehicleItem(i, itemStack);
    }

    @NotNull
    public SlotAccess getSlot(int i) {
        return this.getChestVehicleSlot(i);
    }

    public void setChanged() {
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        if (this.lootTable != null && player.isSpectator()) {
            return null;
        }
        this.unpackLootTable(inventory.player);
        return this.createMenuLootUnpacked(i, inventory, player);
    }

    public abstract AbstractContainerMenu createMenuLootUnpacked(int var1, Inventory var2, Player var3);

    @NotNull
    public NonNullList<ItemStack> getItemStacks() {
        return this.itemStacks;
    }

    public void clearItemStacks() {
        this.itemStacks = NCInventory.withSize((int)this.getContainerSize(), (ItemStack)ItemStack.EMPTY);
        this.itemStacks.setOnContentsChanged(this::onContentsChanged);
    }

    public void stopOpen(Player player) {
        this.level().gameEvent((Holder)GameEvent.CONTAINER_CLOSE, this.position(), GameEvent.Context.of((Entity)player));
    }

    public void onContentsChanged(int slot) {
    }

    @Nullable
    public void unpackLootTable(Player player) {
        this.unpackChestVehicleLootTable(player);
    }

    @Nullable
    public ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }

    public void setLootTable(ResourceKey<LootTable> resourceLocation) {
        this.lootTable = resourceLocation;
    }

    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public void setLootTableSeed(long l) {
        this.lootTableSeed = l;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.saveInventory(compound);
    }

    public abstract void saveInventory(CompoundTag var1);

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.readInventory(compound);
    }

    public abstract void readInventory(CompoundTag var1);
}

