/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.common.entities.carts;

import com.jusipat.astikorcartsredux.AstikorCartsRedux;
import com.jusipat.astikorcartsredux.AstikorCartsReduxConfig;
import com.jusipat.astikorcartsredux.entity.PostilionEntity;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import tfcastikorcarts.common.CartType;
import tfcastikorcarts.common.entities.carts.TFCAbstractDrawnEntity;
import tfcastikorcarts.config.TFCAstikorCartsConfig;

public class TFCAnimalCartEntity
extends TFCAbstractDrawnEntity {
    public PostilionEntity postilionEntity = null;

    public TFCAnimalCartEntity(EntityType<? extends Entity> entityType, Level level, CartType cartType, RegistryWood wood) {
        super(entityType, level, cartType, wood);
    }

    public AstikorCartsReduxConfig.CartConfig getConfig() {
        return AstikorCartsReduxConfig.get().animalCart;
    }

    public void tick() {
        PostilionEntity postilion;
        super.tick();
        LivingEntity coachman = this.getControllingPassenger();
        Entity pulling = this.getPulling();
        if (pulling != null && coachman != null && pulling.getControllingPassenger() == null && (postilion = (PostilionEntity)((EntityType)AstikorCartsRedux.POSTILION_ENTITY.get()).create(this.level())) != null) {
            postilion.moveTo(pulling.getX(), pulling.getY(), pulling.getZ(), coachman.getYRot(), coachman.getXRot());
            if (postilion.startRiding(pulling)) {
                this.level().addFreshEntity((Entity)postilion);
            } else {
                postilion.discard();
            }
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (player.isSecondaryUseActive()) {
            if (!this.level().isClientSide) {
                for (Entity entity : this.getPassengers()) {
                    if (entity instanceof Player) continue;
                    entity.stopRiding();
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        InteractionResult bannerResult = this.useBanner(player, hand);
        if (bannerResult.consumesAction()) {
            return bannerResult;
        }
        if (this.getPulling() != player) {
            if (!this.canAddPassenger((Entity)player)) {
                return InteractionResult.PASS;
            }
            if (!this.level().isClientSide) {
                return player.startRiding((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void push(Entity entityIn) {
        if (!entityIn.hasPassenger((Entity)this)) {
            double animalSize = entityIn.getBoundingBox().getSize();
            double maxAnimalSize = TFCAstikorCartsConfig.COMMON.maxAnimalSize.get();
            if (!this.level().isClientSide && this.getPulling() != entityIn && this.getControllingPassenger() == null && animalSize <= maxAnimalSize && !entityIn.isPassenger() && (entityIn.getBbWidth() < this.getBbWidth() || animalSize <= maxAnimalSize) && entityIn instanceof LivingEntity && TFCAnimalCartEntity.canCarryWaterEntities(entityIn) && TFCAnimalCartEntity.canPushIntoPlayers(entityIn)) {
                entityIn.startRiding((Entity)this);
            } else {
                super.push(entityIn);
            }
        }
    }

    public static boolean canPushIntoPlayers(Entity entityIn) {
        if (entityIn instanceof Player) {
            return TFCAstikorCartsConfig.COMMON.canPushIntoPlayers.get();
        }
        return true;
    }

    public static boolean canCarryWaterEntities(Entity entityIn) {
        if (entityIn instanceof WaterAnimal) {
            return TFCAstikorCartsConfig.COMMON.canCarryWaterEntities.get();
        }
        return true;
    }

    public boolean canAddPassenger(Entity passenger) {
        double maxAnimalSize;
        double animalSize = passenger.getBoundingBox().getSize();
        return animalSize <= (maxAnimalSize = TFCAstikorCartsConfig.COMMON.maxAnimalSize.get().doubleValue()) && this.getPassengers().size() <= TFCAstikorCartsConfig.COMMON.maxPassengerCount.get();
    }

    public float getPassengersRidingOffsetY(EntityDimensions entityDimensions, float f) {
        return (entityDimensions.height() - 0.5f) * f;
    }

    @NotNull
    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        double f1 = -0.1;
        if (this.getPassengers().size() > 1) {
            double d = f1 = this.getPassengers().indexOf(entity) == 0 ? 0.2 : -0.6;
            if (entity instanceof Animal) {
                f1 += 0.2;
            }
        }
        Vec3 forward = this.getLookAngle().scale(f1 + (double)Mth.sin((float)((float)Math.toRadians(this.getXRot()))) * 0.7);
        return new Vec3(forward.x, (double)this.getPassengersRidingOffsetY(entityDimensions, f) + forward.y, forward.z);
    }

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        super.positionRider(passenger, moveFunction);
        if (this.hasPassenger(passenger)) {
            passenger.setYBodyRot(this.getYRot());
            float f2 = Mth.wrapDegrees((float)(passenger.getYRot() - this.getYRot()));
            float f1 = Mth.clamp((float)f2, (float)-105.0f, (float)105.0f);
            passenger.yRotO += f1 - f2;
            passenger.setYRot(passenger.getYRot() + (f1 - f2));
            passenger.setYHeadRot(passenger.getYRot());
            if (passenger instanceof Animal) {
                Animal animal = (Animal)passenger;
                if (this.getPassengers().size() > 1) {
                    int j = animal.getId() % 2 == 0 ? 90 : 270;
                    animal.setYBodyRot(animal.yBodyRot + (float)j);
                    animal.setYHeadRot(animal.getYHeadRot() + (float)j);
                }
            }
        }
    }
}

