/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.common.entities.carts;

import com.google.common.collect.ImmutableList;
import com.jusipat.astikorcartsredux.AstikorCartsReduxConfig;
import com.jusipat.astikorcartsredux.container.PlowMenu;
import com.jusipat.astikorcartsredux.util.ProxyItemUseContext;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import tfcastikorcarts.common.AstikorTags;
import tfcastikorcarts.common.CartType;
import tfcastikorcarts.common.entities.carts.TFCAbstractDrawnInventoryEntity;
import tfcastikorcarts.util.AstikorHelpers;

public class TFCPlowEntity
extends TFCAbstractDrawnInventoryEntity {
    public static final int SLOT_COUNT = 3;
    public static final double BLADEOFFSET = 1.7;
    public static final EntityDataAccessor<Boolean> PLOWING = SynchedEntityData.defineId(TFCPlowEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final ImmutableList<EntityDataAccessor<ItemStack>> TOOLS = ImmutableList.of((Object)SynchedEntityData.defineId(TFCPlowEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(TFCPlowEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(TFCPlowEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK));

    public TFCPlowEntity(EntityType<? extends Entity> entityType, Level level, CartType cartType, RegistryWood wood) {
        super(entityType, level, cartType, wood, 3);
        this.spacing = 1.3;
        this.affectedByCargo = false;
    }

    protected AstikorCartsReduxConfig.CartConfig getConfig() {
        return AstikorCartsReduxConfig.get().plow;
    }

    public boolean getPlowing() {
        return (Boolean)this.entityData.get(PLOWING);
    }

    @Override
    public void pulledTick() {
        super.pulledTick();
        if (this.getPulling() == null) {
            return;
        }
        if (!this.level().isClientSide) {
            Player player = null;
            Entity entity = this.getPulling();
            if (entity instanceof Player) {
                Player pl;
                player = pl = (Player)entity;
            } else {
                entity = this.getPulling().getControllingPassenger();
                if (entity instanceof Player) {
                    Player pl;
                    player = pl = (Player)entity;
                }
            }
            if (((Boolean)this.entityData.get(PLOWING)).booleanValue() && player != null && (this.xo != this.getX() || this.zo != this.getZ())) {
                this.plow(player);
            }
        }
    }

    public void plow(Player player) {
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (!(stack.getItem() instanceof TieredItem)) continue;
            float offset = 38.0f - (float)i * 38.0f;
            double blockPosX = this.getX() + Math.sin(Math.toRadians(this.getYRot() - offset)) * 1.7;
            double blockPosZ = this.getZ() - Math.cos(Math.toRadians(this.getYRot() - offset)) * 1.7;
            Vec3 vec3 = new Vec3(blockPosX, this.getY() - 0.75, blockPosZ);
            BlockPos blockPos = BlockPos.containing((Position)vec3);
            boolean damageable = stack.isDamageableItem();
            int count = stack.getCount();
            for (int k = 0; k < 5; ++k) {
                this.tryBreakBlock(stack, blockPos.above(k), this.level(), player);
            }
            stack.getItem().useOn((UseOnContext)new ProxyItemUseContext(player, stack, new BlockHitResult(Vec3.ZERO, Direction.UP, blockPos, false)));
            if (!damageable || stack.getCount() >= count) continue;
            this.playSound(SoundEvents.ITEM_BREAK, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
            this.updateSlot(i);
        }
    }

    public void tryBreakBlock(ItemStack stack, BlockPos pos, Level level, Player player) {
        TagKey<Block> tag;
        BlockState state = level.getBlockState(pos);
        if (Helpers.isItem((Item)stack.getItem(), (TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)AstikorHelpers.resourceLocation("c", "tools/scythe")))) {
            tag = AstikorTags.Blocks.MINEABLE_PLOW_SCYTHE;
        } else if (Helpers.isItem((Item)stack.getItem(), (TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)AstikorHelpers.resourceLocation("c", "tools/knife")))) {
            tag = AstikorTags.Blocks.MINEABLE_PLOW_KNIFE;
        } else if (Helpers.isItem((Item)stack.getItem(), (TagKey)ItemTags.HOES)) {
            tag = AstikorTags.Blocks.MINEABLE_PLOW_HOE;
        } else if (Helpers.isItem((Item)stack.getItem(), (TagKey)ItemTags.AXES)) {
            tag = AstikorTags.Blocks.MINEABLE_PLOW_AXE;
        } else {
            return;
        }
        if (state.isAir()) {
            return;
        }
        if (state.is(tag) && level.removeBlock(pos, false)) {
            level.destroyBlock(pos, false);
            if (!state.requiresCorrectToolForDrops() || stack.isCorrectToolForDrops(state)) {
                Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos), (Entity)player, (ItemStack)stack);
            }
        }
    }

    @Override
    public AbstractContainerMenu createMenuLootUnpacked(int i, Inventory inventory, Player player) {
        return new PlowMenu(i, inventory, (Container)this);
    }

    @Override
    public void onContentsChanged(int slot) {
        this.updateSlot(slot);
    }

    public void updateSlot(int slot) {
        if (!this.level().isClientSide) {
            if (((ItemStack)this.getItemStacks().get(slot)).isEmpty()) {
                this.entityData.set((EntityDataAccessor)TOOLS.get(slot), (Object)ItemStack.EMPTY);
            } else {
                this.entityData.set((EntityDataAccessor)TOOLS.get(slot), (Object)((ItemStack)this.getItemStacks().get(slot)));
            }
        }
    }

    public ItemStack getStackInSlot(int i) {
        return (ItemStack)this.entityData.get((EntityDataAccessor)TOOLS.get(i));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PLOWING, (Object)false);
        for (EntityDataAccessor param : TOOLS) {
            builder.define(param, (Object)ItemStack.EMPTY);
        }
    }

    @Override
    public InteractionResult onInteractNotOpen(Player player, InteractionHand hand) {
        if (!this.level().isClientSide) {
            this.entityData.set(PLOWING, (Object)((Boolean)this.entityData.get(PLOWING) == false ? 1 : 0));
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    @Override
    public void saveInventory(CompoundTag tag) {
        ContainerHelper.saveAllItems((CompoundTag)tag, this.getItemStacks(), (HolderLookup.Provider)this.registryAccess());
    }

    @Override
    public void readInventory(CompoundTag tag) {
        ContainerHelper.loadAllItems((CompoundTag)tag, this.getItemStacks(), (HolderLookup.Provider)this.registryAccess());
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Plowing", ((Boolean)this.entityData.get(PLOWING)).booleanValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(PLOWING, (Object)compound.getBoolean("Plowing"));
    }
}

