/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.common.items;

import com.jusipat.astikorcartsredux.AstikorCartsRedux;
import com.jusipat.astikorcartsredux.item.CartItem;
import java.util.List;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import tfcastikorcarts.common.CartType;
import tfcastikorcarts.common.entities.AstikorEntities;
import tfcastikorcarts.common.entities.carts.TFCAbstractDrawnEntity;

public class TFCCartItem
extends CartItem {
    public final RegistryWood woodType;
    public final CartType cartType;

    public TFCCartItem(RegistryWood woodType, CartType cartType, Item.Properties settings) {
        super(woodType.getVanillaWoodType(), cartType.getSerializedName() + "/" + woodType.getSerializedName(), settings);
        this.woodType = woodType;
        this.cartType = cartType;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.empty());
        list.add((Component)Component.translatable((String)("item.tfcastikorcarts." + this.cartType.getSerializedName() + ".tooltip1"), (Object[])new Object[]{this.cartType.getContainerSize()}).withStyle(ChatFormatting.GRAY));
        list.add((Component)Component.translatable((String)("item.tfcastikorcarts." + this.cartType.getSerializedName() + ".tooltip2"), (Object[])new Object[]{this.cartType.getContainerSize()}).withStyle(ChatFormatting.GRAY));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack stack = player.getItemInHand(interactionHand);
        BlockHitResult result = TFCCartItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (result.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)stack);
        }
        Vec3 lookVec = player.getLookAngle();
        List list = level.getEntities((Entity)player, player.getBoundingBox().expandTowards(lookVec.scale(5.0)).inflate(5.0), EntitySelector.NO_SPECTATORS.and(Entity::canBeCollidedWith));
        if (!list.isEmpty()) {
            Vec3 eyePos = player.getEyePosition(1.0f);
            for (Entity entity : list) {
                AABB axisalignedbb = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!axisalignedbb.contains(eyePos)) continue;
                return InteractionResultHolder.pass((Object)stack);
            }
        }
        if (result.getType() == HitResult.Type.BLOCK) {
            EntityType type = (EntityType)AstikorEntities.CART_ENTITIES.get((Object)this.cartType).get(this.woodType).get();
            Entity cart = type.create(level);
            if (cart == null) {
                return InteractionResultHolder.pass((Object)stack);
            }
            if (cart instanceof TFCAbstractDrawnEntity) {
                TFCAbstractDrawnEntity drawn = (TFCAbstractDrawnEntity)cart;
                drawn.setTFCWoodType(this.woodType);
            }
            cart.moveTo(result.getLocation().x, result.getLocation().y, result.getLocation().z);
            cart.setYRot((player.getYRot() + 180.0f) % 360.0f);
            if (!level.noCollision(cart, cart.getBoundingBox().inflate((double)0.1f, (double)-0.1f, (double)0.1f))) {
                return InteractionResultHolder.fail((Object)stack);
            }
            if (!level.isClientSide()) {
                level.addFreshEntity(cart);
                level.playSound(null, cart.getX(), cart.getY(), cart.getZ(), AstikorCartsRedux.PLACE_SOUND, SoundSource.BLOCKS, 0.75f, 0.8f);
            }
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }
}

