/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.config;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.neoforged.neoforge.common.ModConfigSpec;
import tfcastikorcarts.config.TFCAstikorCartsConfig;

public class TFCAConfigBuilder {
    private final ModConfigSpec.Builder builder;
    private final Factory factory;
    private final String translationKeyPrefix;
    private boolean emptyLineAdded;

    public TFCAConfigBuilder(ModConfigSpec.Builder builder, Factory factory, String translationKeyPrefix) {
        this.builder = builder;
        this.factory = factory;
        this.translationKeyPrefix = translationKeyPrefix;
        this.emptyLineAdded = false;
    }

    public TFCAConfigBuilder push(String path) {
        this.builder.push(path);
        return this;
    }

    public TFCAConfigBuilder swap(String path) {
        this.builder.pop().push(path);
        return this;
    }

    public TFCAConfigBuilder pop() {
        this.builder.pop();
        return this;
    }

    public TFCAConfigBuilder pop(int n) {
        for (int i = 0; i < n; ++i) {
            this.pop();
        }
        return this;
    }

    public TFCAConfigBuilder comment(String ... text) {
        if (!this.emptyLineAdded) {
            this.builder.comment("");
            this.emptyLineAdded = true;
        }
        for (String line : text) {
            this.builder.comment(" " + line);
        }
        return this;
    }

    public Supplier<Boolean> define(String path, boolean value) {
        return this.factory.create(this.begin(path).define(path, value));
    }

    public Supplier<Integer> define(String path, int value, int min, int max) {
        return this.factory.create(this.begin(path).defineInRange(path, value, min, max));
    }

    public Supplier<Integer> define(String path, int value) {
        return this.factory.create(this.begin(path).define(path, (Object)value));
    }

    public Supplier<Double> define(String path, double value, double min, double max) {
        return this.factory.create(this.begin(path).defineInRange(path, value, min, max));
    }

    public Supplier<String> define(String path, String value) {
        return this.factory.create(this.begin(path).define(path, (Object)value));
    }

    public <E extends Enum<E>> Supplier<E> define(String path, E value) {
        return this.factory.create(this.begin(path).defineEnum(path, value));
    }

    public Supplier<List<String>> define(String path, List<String> value, Predicate<String> predicate) {
        return this.factory.create(this.begin(path).defineListAllowEmpty(path, new ArrayList<String>(value), String::new, o -> {
            String s;
            return o instanceof String && predicate.test(s = (String)o);
        }));
    }

    private ModConfigSpec.Builder begin(String path) {
        this.builder.translation("tfc.config." + this.translationKeyPrefix + "." + path);
        this.emptyLineAdded = false;
        return this.builder;
    }

    public static interface Factory {
        public <T, V extends ModConfigSpec.ConfigValue<T>> Supplier<T> create(V var1);
    }

    public record CommonValue<T>(ModConfigSpec.ConfigValue<T> value) implements Supplier<T>
    {
        @Override
        public T get() {
            return (T)(TFCAstikorCartsConfig.COMMON.spec().isLoaded() ? this.value.get() : this.value.getDefault());
        }
    }
}

