/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import tfcastikorcarts.datagen.TFCAstikorBlockTagProvider;
import tfcastikorcarts.datagen.TFCAstikorItemTagProvider;
import tfcastikorcarts.datagen.TFCAstikorLootTableProvider;
import tfcastikorcarts.datagen.TFCAstikorRecipeProvider;

public class DataGenerators {
    public static void init(IEventBus bus) {
        bus.addListener(DataGenerators::gatherData);
    }

    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        TFCAstikorBlockTagProvider blockTagsProvider = new TFCAstikorBlockTagProvider(output, lookupProvider, "tfcastikorcarts", existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new TFCAstikorRecipeProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new TFCAstikorLootTableProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new TFCAstikorItemTagProvider(output, lookupProvider, blockTagsProvider.contentsGetter(), "tfcastikorcarts", existingFileHelper));
    }
}

