/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;
import tfcastikorcarts.common.AstikorTags;
import tfcastikorcarts.common.CartType;
import tfcastikorcarts.common.items.AstikorItems;
import tfcregistryapi.util.WoodRegistryHelper;

public class TFCAstikorItemTagProvider
extends ItemTagsProvider {
    public TFCAstikorItemTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTags, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, blockTags, modId, existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.tag(AstikorTags.Items.CART_WHEEL).add((Object[])((Item[])WoodRegistryHelper.getAllWoodValues().stream().map(AstikorItems.WHEELS::get).toArray(Item[]::new)));
        for (CartType type : CartType.values()) {
            this.tag(switch (type) {
                case CartType.ANIMAL_CART -> AstikorTags.Items.ANIMAL_CART;
                case CartType.HAND_CART -> AstikorTags.Items.HAND_CART;
                case CartType.PLOW -> AstikorTags.Items.PLOW;
                case CartType.REAPER -> AstikorTags.Items.REAPER;
                case CartType.SEED_DRILL -> AstikorTags.Items.SEED_DRILL;
                case CartType.SUPPLY_CART -> AstikorTags.Items.SUPPLY_CART;
                default -> throw new IllegalStateException("Unexpected cart type: " + String.valueOf((Object)type));
            }).add((Object[])((Item[])WoodRegistryHelper.getAllWoodValues().stream().map(wood -> AstikorItems.CART_ITEMS.get((Object)type).get(wood)).toArray(Item[]::new)));
        }
    }
}

