/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.datagen;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import tfcastikorcarts.common.CartType;
import tfcastikorcarts.common.items.AstikorItems;
import tfcastikorcarts.util.AstikorHelpers;
import tfcregistryapi.util.WoodRegistryHelper;

public class TFCAstikorLootTableProvider
extends LootTableProvider {
    public TFCAstikorLootTableProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(p -> new CartLootTables(), LootContextParamSets.ENTITY)), registries);
    }

    public static class CartLootTables
    implements LootTableSubProvider {
        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            for (CartType cart : CartType.values()) {
                for (RegistryWood wood : WoodRegistryHelper.getAllWoodValues()) {
                    ResourceKey key = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)AstikorHelpers.identifier("entities/" + cart.getSerializedName() + "/" + wood.getSerializedName()));
                    LootTable.Builder builder = LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AstikorItems.WHEELS.get(wood).get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))));
                    consumer.accept((ResourceKey<LootTable>)key, builder);
                }
            }
        }
    }
}

