/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.datagen;

import java.util.concurrent.CompletableFuture;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import tfcastikorcarts.common.CartType;
import tfcastikorcarts.common.items.AstikorItems;
import tfcastikorcarts.util.AstikorHelpers;
import tfcregistryapi.util.WoodRegistryHelper;

public class TFCAstikorRecipeProvider
extends RecipeProvider {
    RecipeOutput output;
    HolderLookup.Provider lookup;

    public TFCAstikorRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    @NotNull
    public CompletableFuture<?> run(CachedOutput cachedOutput, HolderLookup.Provider lookup) {
        this.lookup = lookup;
        return super.run(cachedOutput, lookup);
    }

    protected void buildRecipes(@NotNull RecipeOutput recipeOutput) {
        this.output = recipeOutput;
        for (RegistryWood wood : WoodRegistryHelper.getAllWoodValues()) {
            Block plank = WoodRegistryHelper.getWoodBlock((RegistryWood)wood, (TagKey)BlockTags.PLANKS, (String)"planks", (boolean)true);
            Block slab = WoodRegistryHelper.getWoodBlock((RegistryWood)wood, (TagKey)BlockTags.WOODEN_SLABS, (String)"plank", (boolean)true);
            Item wheel = (Item)AstikorItems.WHEELS.get(wood).get();
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)wheel).pattern("sss").pattern("sps").pattern("sss").define(Character.valueOf('p'), (ItemLike)plank).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy("has_planks", TFCAstikorRecipeProvider.has((ItemLike)plank)).save(this.output, AstikorHelpers.identifier("wheel/" + wood.getSerializedName()));
            block9: for (CartType cart : CartType.values()) {
                Item result = (Item)AstikorItems.CART_ITEMS.get((Object)cart).get(wood).get();
                switch (cart) {
                    case ANIMAL_CART: {
                        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("ppp").pattern("ppp").pattern("wpw").define(Character.valueOf('p'), (ItemLike)plank).define(Character.valueOf('w'), (ItemLike)wheel).unlockedBy("has_wheel", TFCAstikorRecipeProvider.has((ItemLike)wheel)).save(this.output, this.id(cart, wood));
                        continue block9;
                    }
                    case HAND_CART: {
                        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("pcp").pattern("wpw").define(Character.valueOf('p'), (ItemLike)plank).define(Character.valueOf('w'), (ItemLike)wheel).define(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).unlockedBy("has_wheel", TFCAstikorRecipeProvider.has((ItemLike)wheel)).save(this.output, this.id(cart, wood));
                        continue block9;
                    }
                    case PLOW: {
                        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("sss").pattern("psp").pattern("wpw").define(Character.valueOf('p'), (ItemLike)plank).define(Character.valueOf('w'), (ItemLike)wheel).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy("has_wheel", TFCAstikorRecipeProvider.has((ItemLike)wheel)).save(this.output, this.id(cart, wood));
                        continue block9;
                    }
                    case REAPER: {
                        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern(" sl").pattern("spp").pattern("iww").define(Character.valueOf('p'), (ItemLike)plank).define(Character.valueOf('w'), (ItemLike)wheel).define(Character.valueOf('s'), (ItemLike)Items.STICK).define(Character.valueOf('l'), (ItemLike)slab).define(Character.valueOf('i'), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)AstikorHelpers.resourceLocation("c", "double_sheets"))).unlockedBy("has_wheel", TFCAstikorRecipeProvider.has((ItemLike)wheel)).save(this.output, this.id(cart, wood));
                        continue block9;
                    }
                    case SEED_DRILL: {
                        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("pcp").pattern("php").pattern("wpw").define(Character.valueOf('p'), (ItemLike)plank).define(Character.valueOf('w'), (ItemLike)wheel).define(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).define(Character.valueOf('h'), (ItemLike)Items.HOPPER).unlockedBy("has_wheel", TFCAstikorRecipeProvider.has((ItemLike)wheel)).save(this.output, this.id(cart, wood));
                        continue block9;
                    }
                    case SUPPLY_CART: {
                        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("pcp").pattern("pcp").pattern("wpw").define(Character.valueOf('p'), (ItemLike)plank).define(Character.valueOf('w'), (ItemLike)wheel).define(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).unlockedBy("has_wheel", TFCAstikorRecipeProvider.has((ItemLike)wheel)).save(this.output, this.id(cart, wood));
                    }
                }
            }
        }
    }

    public ResourceLocation id(CartType cart, RegistryWood wood) {
        return AstikorHelpers.identifier(cart.getSerializedName() + "/" + wood.getSerializedName());
    }
}

