/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.affogatotweaks.mixson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import net.ramixin.mixson.inline.Mixson;
import net.ramixin.mixson.inline.ResourceReference;

public class LootTableEvents {
    private static final Object2IntMap<String> REPLACEMENT_MAP = new Object2IntArrayMap(Map.ofEntries(Map.entry("minecraft:diamond_helmet", 5), Map.entry("minecraft:diamond_chestplate", 8), Map.entry("minecraft:diamond_leggings", 7), Map.entry("minecraft:diamond_boots", 4), Map.entry("minecraft:diamond_pickaxe", 3), Map.entry("minecraft:diamond_axe", 3), Map.entry("minecraft:diamond_shovel", 1), Map.entry("minecraft:diamond_sword", 2), Map.entry("minecraft:diamond_hoe", 2), Map.entry("minecraft:iron_helmet", 5), Map.entry("minecraft:iron_chestplate", 8), Map.entry("minecraft:iron_leggings", 7), Map.entry("minecraft:iron_boots", 4), Map.entry("minecraft:iron_pickaxe", 3), Map.entry("minecraft:iron_axe", 3), Map.entry("minecraft:iron_shovel", 1), Map.entry("minecraft:iron_sword", 2), Map.entry("minecraft:iron_hoe", 2)));
    private static final Object2DoubleMap<String> TOTEM_MAP = new Object2DoubleArrayMap(Map.ofEntries(Map.entry("jungle_temple", 0.5), Map.entry("pillager_outpost", 0.75), Map.entry("woodland_mansion", 1.0)));

    public static void register() {
        Mixson.registerEvent((int)1000, rl -> rl.method_12832().startsWith("loot_table/chests/"), (String)"Replace tools and armor in loot chests with materials", context -> {
            JsonArray updatedPools = new JsonArray();
            ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonArray("pools").forEach(pool -> {
                JsonObject updatedPool = pool.getAsJsonObject().deepCopy();
                JsonArray updatedEntries = new JsonArray();
                pool.getAsJsonObject().getAsJsonArray("entries").forEach(entry -> {
                    if (entry.getAsJsonObject().has("name")) {
                        String itemName = entry.getAsJsonObject().getAsJsonPrimitive("name").getAsString();
                        if (REPLACEMENT_MAP.containsKey((Object)itemName)) {
                            JsonElement replacementEntry = JsonParser.parseString((String)"{\n  \"type\": \"minecraft:item\",\n  \"functions\": [\n    {\n      \"function\": \"minecraft:set_count\"\n    }\n  ]\n}").deepCopy();
                            replacementEntry.getAsJsonObject().addProperty("name", itemName.contains("diamond") ? "minecraft:diamond" : "minecraft:iron_ingot");
                            replacementEntry.getAsJsonObject().getAsJsonArray("functions").get(0).getAsJsonObject().addProperty("count", (Number)REPLACEMENT_MAP.getInt((Object)itemName));
                            updatedEntries.add(replacementEntry);
                        } else {
                            updatedEntries.add(entry);
                        }
                    } else {
                        updatedEntries.add(entry);
                    }
                });
                updatedPool.add("entries", (JsonElement)updatedEntries);
                updatedPools.add((JsonElement)updatedPool);
            });
            ((JsonElement)context.getFile()).getAsJsonObject().add("pools", (JsonElement)updatedPools);
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]);
        Mixson.registerEvent((int)1000, rl -> rl.toString().equals("minecraft:loot_table/chests/simple_dungeon") || rl.toString().equals("minecraft:loot_table/chests/abandoned_mineshaft"), (String)"Distribute trial explorer map to dungeons and abandoned mineshafts", context -> {
            JsonElement pool = JsonParser.parseString((String)"{\n  \"rolls\": 1,\n  \"entries\": [\n    {\n      \"type\": \"minecraft:item\",\n      \"functions\": [\n        {\n          \"function\": \"minecraft:exploration_map\",\n          \"destination\": \"minecraft:on_trial_chambers_maps\",\n          \"decoration\": \"minecraft:trial_chambers\",\n          \"zoom\": 2\n        },\n        {\n          \"function\": \"minecraft:set_name\",\n          \"name\": {\n            \"translate\": \"filled_map.trial_chambers\"\n          },\n          \"target\": \"item_name\"\n        }\n      ],\n      \"name\": \"minecraft:map\"\n    }\n  ],\n  \"conditions\": [\n    {\n      \"condition\": \"minecraft:random_chance\",\n      \"chance\": 0.08\n    }\n  ]\n}\n").deepCopy();
            ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonArray("pools").add(pool);
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]);
        Mixson.registerEvent((int)1000, rl -> rl.toString().equals("minecraft:loot_table/chests/woodland_mansion"), (String)"Distribute Globe banner pattern to woodland mansion chest", context -> {
            JsonElement pool = JsonParser.parseString((String)"{\n  \"rolls\": 1.0,\n  \"entries\": [\n    {\n      \"type\": \"minecraft:item\",\n      \"name\": \"minecraft:globe_banner_pattern\"\n    }\n  ]\n}\n").deepCopy();
            ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonArray("pools").add(pool);
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]);
        Mixson.registerEvent((int)1000, rl -> rl.toString().equals("minecraft:loot_table/chests/pillager_outpost"), (String)"Distribute woodland explorer map to pillager outpost chest", context -> {
            JsonElement pool = JsonParser.parseString((String)"{\n  \"rolls\": 1.0,\n  \"entries\": [\n    {\n      \"type\": \"minecraft:item\",\n      \"functions\": [\n        {\n          \"function\": \"minecraft:exploration_map\",\n          \"destination\": \"minecraft:on_woodland_explorer_maps\",\n          \"decoration\": \"minecraft:mansion\",\n          \"zoom\": 2\n        },\n        {\n          \"function\": \"minecraft:set_name\",\n          \"name\": {\n            \"translate\": \"filled_map.mansion\"\n          },\n          \"target\": \"item_name\"\n        }\n      ],\n      \"name\": \"minecraft:map\"\n    }\n  ],\n  \"conditions\": [\n    {\n      \"condition\": \"minecraft:random_chance\",\n      \"chance\": 0.33\n    }\n  ]\n}\n").deepCopy();
            ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonArray("pools").add(pool);
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]);
        Mixson.registerEvent((int)1000, rl -> rl.toString().equals("minecraft:loot_table/chests/shipwreck_map"), (String)"Distribute ocean explorer map to shipwreck map chest", context -> {
            JsonElement pool = JsonParser.parseString((String)"{\n  \"rolls\": 1,\n  \"entries\": [\n    {\n      \"type\": \"minecraft:item\",\n      \"functions\": [\n        {\n          \"function\": \"minecraft:exploration_map\",\n          \"destination\": \"minecraft:on_ocean_explorer_maps\",\n          \"decoration\": \"minecraft:monument\",\n          \"zoom\": 2\n        },\n        {\n          \"function\": \"minecraft:set_name\",\n          \"name\": {\n            \"translate\": \"filled_map.monument\"\n          },\n          \"target\": \"item_name\"\n        }\n      ],\n      \"name\": \"minecraft:map\"\n    }\n  ],\n  \"conditions\": [\n    {\n      \"condition\": \"minecraft:random_chance\",\n      \"chance\": 0.5\n    }\n  ]\n}\n").deepCopy();
            ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonArray("pools").add(pool);
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]);
        TOTEM_MAP.forEach((key, value) -> Mixson.registerEvent((int)1000, rl -> rl.toString().equals("minecraft:loot_table/chests/" + key), (String)"Distribute Totem of Undying to loot chests", context -> {
            JsonElement pool = JsonParser.parseString((String)"{\n  \"rolls\": 1.0,\n  \"entries\": [\n    {\n      \"type\": \"minecraft:item\"\n    }\n  ],\n  \"conditions\": [\n    {\n      \"condition\": \"minecraft:random_chance\"\n    }\n  ]\n}\n").deepCopy();
            pool.getAsJsonObject().getAsJsonArray("entries").get(0).getAsJsonObject().addProperty("name", "minecraft:totem_of_undying");
            pool.getAsJsonObject().getAsJsonArray("conditions").get(0).getAsJsonObject().addProperty("chance", (Number)value);
            ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonArray("pools").add(pool);
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]));
        Mixson.registerEvent((int)1000, rl -> rl.toString().equals("minecraft:loot_table/blocks/oak_leaves") || rl.toString().equals("minecraft:loot_table/blocks/dark_oak_leaves"), (String)"Increase apple drop chance", context -> {
            JsonArray pools = ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonArray("pools");
            for (JsonElement pool : pools) {
                JsonArray updatedEntries = new JsonArray();
                JsonArray entries = pool.getAsJsonObject().getAsJsonArray("entries");
                for (JsonElement entry : entries) {
                    if (!entry.getAsJsonObject().has("name") || !entry.getAsJsonObject().get("name").getAsString().equals("minecraft:apple")) continue;
                    updatedEntries = entries.deepCopy();
                    updatedEntries.remove(entry);
                    updatedEntries.add(JsonParser.parseString((String)"{\n  \"type\": \"minecraft:item\",\n  \"name\": \"minecraft:apple\",\n  \"conditions\": [\n    {\n      \"condition\": \"minecraft:random_chance\",\n      \"chance\": 0.025\n    }\n  ]\n}\n").deepCopy());
                    break;
                }
                if (updatedEntries.isEmpty()) continue;
                pool.getAsJsonObject().add("entries", (JsonElement)updatedEntries);
                break;
            }
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]);
    }
}

