/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.affogatotweaks.shaderlock;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.stream.Stream;
import me.pajic.affogatotweaks.Main;
import me.pajic.affogatotweaks.shaderlock.SHA256;
import net.fabricmc.loader.api.FabricLoader;
import net.irisshaders.iris.Iris;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaderLock {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ShaderLock");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path filePath = FabricLoader.getInstance().getConfigDir().resolve("shaderlock");
    public static boolean setupMode = false;

    public static boolean shaderAllowed(String name) throws IOException, NoSuchAlgorithmException {
        Path shaderPackPath = Paths.get(String.valueOf(Iris.getShaderpacksDirectory()) + File.separator + name, new String[0]);
        File shaderPack = shaderPackPath.toFile();
        if (shaderPack.isDirectory()) {
            Object2ObjectArrayMap fileHashes = new Object2ObjectArrayMap();
            try (Stream<Path> fileStream = Files.walk(shaderPackPath, new FileVisitOption[0]);){
                fileStream.forEach(arg_0 -> ShaderLock.lambda$shaderAllowed$0((Map)fileHashes, shaderPackPath, arg_0));
            }
            return ShaderLock.compare(name, (Map<String, String>)fileHashes);
        }
        if (shaderPack.isFile()) {
            return ShaderLock.compare(name, Map.of(name, SHA256.calculateSHA256(shaderPack)));
        }
        return false;
    }

    private static boolean compare(String name, Map<String, String> fileHashes) throws IOException {
        InputStream is = Main.class.getResourceAsStream("/" + name + "_sha256");
        if (setupMode) {
            try (FileWriter fw = new FileWriter(String.valueOf(Iris.getShaderpacksDirectory()) + File.separator + name + "_sha256");){
                GSON.toJson(fileHashes, (Appendable)fw);
                fw.flush();
            }
        }
        if (is != null) {
            return fileHashes.equals(GSON.fromJson((Reader)new InputStreamReader(is), new TypeToken<Map<String, String>>(){}.getType()));
        }
        return false;
    }

    public static void read() {
        try (FileReader reader = new FileReader(filePath.toFile());){
            setupMode = (Boolean)GSON.fromJson((Reader)reader, Boolean.TYPE);
            if (setupMode) {
                LOGGER.info("Setup mode enabled");
            }
        }
        catch (JsonSyntaxException | FileNotFoundException e) {
            if (e instanceof JsonSyntaxException) {
                LOGGER.info("Incorrect syntax: {}", (Object)e.getMessage());
            } else {
                LOGGER.info("File not found");
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to read file", (Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$shaderAllowed$0(Map fileHashes, Path shaderPackPath, Path path) {
        try {
            String fileName = path.toString().substring(path.toString().lastIndexOf(File.separator) + 1);
            File f = path.toFile();
            if (!fileName.startsWith(".") && !f.isDirectory()) {
                fileHashes.put(shaderPackPath.relativize(path).toString(), SHA256.calculateSHA256(path.toFile()));
            }
        }
        catch (IOException | NoSuchAlgorithmException e) {
            LOGGER.error("Failed to open file for hash calculation", (Throwable)e);
        }
    }
}

