/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.affogatotweaks.shaderlock;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HexFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHA256 {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ShaderLock");

    public static String calculateSHA256(File file) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        try (FileInputStream fis = new FileInputStream(file);){
            int len;
            byte[] buf = new byte[4096];
            while ((len = fis.read(buf)) != -1) {
                md.update(buf, 0, len);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to open file for hash calculation", (Throwable)e);
        }
        byte[] digest = md.digest();
        return HexFormat.of().formatHex(digest);
    }
}

