/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.affogatotweaks.mixson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.List;
import net.ramixin.mixson.inline.Mixson;
import net.ramixin.mixson.inline.ResourceReference;

public class WorldgenDataEvents {
    private static final List<String> ORE = List.of("coal", "copper", "diamond", "emerald", "gold", "iron", "lapis", "nether_gold", "quartz", "redstone");

    public static void register() {
        Mixson.registerEvent((int)1000, rl -> rl.method_12832().startsWith("worldgen/template_pool/village") && rl.method_12832().endsWith("town_centers"), (String)"Remove normal village spawns", context -> {
            JsonArray elements = ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonArray("elements");
            JsonArray updatedElements = new JsonArray();
            elements.forEach(element -> {
                if (element.getAsJsonObject().getAsJsonObject("element").getAsJsonPrimitive("location").getAsString().contains("zombie")) {
                    updatedElements.add(element);
                }
            });
            ((JsonElement)context.getFile()).getAsJsonObject().add("elements", (JsonElement)updatedElements);
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]);
        Mixson.registerEvent((int)1000, rl -> rl.method_12832().startsWith("worldgen/configured_feature/ore_ancient_debris"), (String)"Increase max ancient debris vein size and allow air exposure", context -> {
            ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonObject("config").addProperty("discard_chance_on_air_exposure", (Number)0);
            ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonObject("config").addProperty("size", (Number)6);
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]);
        Mixson.registerEvent((int)1000, rl -> rl.method_12832().startsWith("worldgen/placed_feature/ore_ancient_debris_large"), (String)"Remove height limit for large ancient debris spawns", context -> {
            JsonArray placement = ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonArray("placement");
            JsonArray updatedPlacement = new JsonArray();
            placement.forEach(element -> {
                if (!element.getAsJsonObject().getAsJsonPrimitive("type").getAsString().equals("minecraft:height_range")) {
                    updatedPlacement.add(element);
                }
            });
            updatedPlacement.add(JsonParser.parseString((String)"{\n    \"type\": \"minecraft:height_range\",\n    \"height\": {\n        \"type\": \"minecraft:uniform\",\n        \"max_inclusive\": {\n          \"below_top\": 8\n        },\n        \"min_inclusive\": {\n          \"absolute\": 8\n        }\n    }\n}"));
            ((JsonElement)context.getFile()).getAsJsonObject().add("placement", (JsonElement)updatedPlacement);
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]);
        ORE.forEach(ore -> Mixson.registerEvent((int)1000, rl -> rl.toString().startsWith("minecraft:worldgen/configured_feature/ore_" + ore), (String)("Increase " + ore + " ore size"), context -> ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonObject("config").addProperty("size", (Number)Math.round((float)((JsonElement)context.getFile()).getAsJsonObject().getAsJsonObject("config").getAsJsonPrimitive("size").getAsInt() * 1.2f)), (boolean)true, (ResourceReference[])new ResourceReference[0]));
        Mixson.registerEvent((int)1000, rl -> rl.toString().startsWith("minecraft:worldgen/placed_feature/monster_room") || rl.toString().startsWith("repurposed_structures:worldgen/placed_feature/dungeons/"), (String)"Increase dungeon spawn rate", context -> {
            JsonArray placement = ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonArray("placement");
            for (JsonElement element : placement) {
                JsonObject object = element.getAsJsonObject();
                String type = object.getAsJsonPrimitive("type").getAsString();
                if (!type.equals("minecraft:count") && !type.equals("repurposed_structures:unlimited_count")) continue;
                object.addProperty("count", (Number)Math.round((float)object.getAsJsonPrimitive("count").getAsInt() * 1.3f));
            }
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]);
        Mixson.registerEvent((int)1000, rl -> rl.toString().equals("minecraft:worldgen/structure_set/mineshafts") || rl.toString().startsWith("repurposed_structures:worldgen/structure_set/mineshafts"), (String)"Increase mineshaft spawn rate", context -> ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonObject("placement").addProperty("frequency", (Number)Float.valueOf(((JsonElement)context.getFile()).getAsJsonObject().getAsJsonObject("placement").getAsJsonPrimitive("frequency").getAsFloat() * 1.5f)), (boolean)true, (ResourceReference[])new ResourceReference[0]);
        Mixson.registerEvent((int)1000, rl -> rl.toString().equals("minecraft:worldgen/biome/jungle"), (String)"Fix ocelots being counted as monsters during spawning", context -> {
            JsonArray monsters = ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonObject("spawners").getAsJsonArray("monster");
            JsonArray creatures = ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonObject("spawners").getAsJsonArray("creature");
            int idToRemove = -1;
            JsonObject ocelot = new JsonObject();
            for (int i = 0; i < monsters.size(); ++i) {
                JsonObject monster = monsters.get(i).getAsJsonObject();
                if (!monster.get("type").getAsString().equals("minecraft:ocelot")) continue;
                idToRemove = i;
                ocelot.addProperty("type", "minecraft:ocelot");
                ocelot.addProperty("maxCount", (Number)monster.get("maxCount").getAsInt());
                ocelot.addProperty("minCount", (Number)monster.get("minCount").getAsInt());
                ocelot.addProperty("weight", (Number)monster.get("weight").getAsInt());
                break;
            }
            if (idToRemove != -1) {
                monsters.remove(idToRemove);
            }
            if (!ocelot.isEmpty()) {
                creatures.add((JsonElement)ocelot);
            }
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]);
    }
}

