/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.affogatotweaks.mixin.shaderlock;

import com.moulberry.mixinconstraints.annotations.IfModLoaded;
import java.io.IOException;
import me.pajic.affogatotweaks.shaderlock.ShaderLock;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.config.IrisConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@IfModLoaded(value="iris")
@Mixin(value={IrisConfig.class}, remap=false)
public abstract class IrisConfigMixin {
    @Shadow
    private String shaderPackName;
    @Shadow
    private boolean enableShaders;

    @Shadow
    public abstract void save() throws IOException;

    @Inject(method={"load"}, at={@At(value="TAIL")})
    private void clearShaderIfNotAllowed(CallbackInfo ci) {
        try {
            if (!ShaderLock.isShaderAllowed(this.shaderPackName)) {
                this.enableShaders = false;
                this.shaderPackName = null;
                try {
                    this.save();
                }
                catch (IOException e) {
                    Iris.logger.error("Exception while saving config file" + String.valueOf(e));
                }
            }
        }
        catch (IOException e) {
            ShaderLock.LOGGER.error("Unable to check if shader is allowed", (Throwable)e);
        }
    }
}

