/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.affogatotweaks.mixson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import me.pajic.affogatotweaks.values.LootValues;
import net.ramixin.mixson.inline.Mixson;
import net.ramixin.mixson.inline.ResourceReference;

public class LootTableEvents {
    public static void register() {
        Mixson.registerEvent((int)1000, rl -> rl.method_12832().startsWith("loot_table/chests/"), (String)"Replace tools and armor in loot chests with materials", context -> {
            JsonArray updatedPools = new JsonArray();
            ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonArray("pools").forEach(pool -> {
                JsonObject updatedPool = pool.getAsJsonObject().deepCopy();
                JsonArray updatedEntries = new JsonArray();
                pool.getAsJsonObject().getAsJsonArray("entries").forEach(entry -> {
                    if (entry.getAsJsonObject().has("name")) {
                        String itemName = entry.getAsJsonObject().getAsJsonPrimitive("name").getAsString();
                        if (LootValues.TOOL_TO_MATERIAL_AMOUNT.containsKey((Object)itemName)) {
                            JsonElement replacementEntry = JsonParser.parseString((String)"{\n  \"type\": \"minecraft:item\",\n  \"functions\": [\n    {\n      \"function\": \"minecraft:set_count\"\n    }\n  ]\n}").deepCopy();
                            replacementEntry.getAsJsonObject().addProperty("name", itemName.contains("diamond") ? "minecraft:diamond" : "minecraft:iron_ingot");
                            replacementEntry.getAsJsonObject().getAsJsonArray("functions").get(0).getAsJsonObject().addProperty("count", (Number)LootValues.TOOL_TO_MATERIAL_AMOUNT.getInt((Object)itemName));
                            updatedEntries.add(replacementEntry);
                        } else {
                            updatedEntries.add(entry);
                        }
                    } else {
                        updatedEntries.add(entry);
                    }
                });
                updatedPool.add("entries", (JsonElement)updatedEntries);
                updatedPools.add((JsonElement)updatedPool);
            });
            ((JsonElement)context.getFile()).getAsJsonObject().add("pools", (JsonElement)updatedPools);
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]);
        Mixson.registerEvent((int)1000, rl -> rl.toString().equals("minecraft:loot_table/chests/simple_dungeon") || rl.toString().equals("minecraft:loot_table/chests/abandoned_mineshaft"), (String)"Distribute trial explorer map to dungeons and abandoned mineshafts", context -> {
            JsonElement pool = JsonParser.parseString((String)"{\n  \"rolls\": 1,\n  \"entries\": [\n    {\n      \"type\": \"minecraft:item\",\n      \"functions\": [\n        {\n          \"function\": \"minecraft:exploration_map\",\n          \"destination\": \"minecraft:on_trial_chambers_maps\",\n          \"decoration\": \"minecraft:trial_chambers\",\n          \"zoom\": 2\n        },\n        {\n          \"function\": \"minecraft:set_name\",\n          \"name\": {\n            \"translate\": \"filled_map.trial_chambers\"\n          },\n          \"target\": \"item_name\"\n        }\n      ],\n      \"name\": \"minecraft:map\"\n    }\n  ],\n  \"conditions\": [\n    {\n      \"condition\": \"minecraft:random_chance\"\n    }\n  ]\n}\n").deepCopy();
            pool.getAsJsonObject().getAsJsonArray("conditions").get(0).getAsJsonObject().addProperty("chance", (Number)0.08);
            ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonArray("pools").add(pool);
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]);
        Mixson.registerEvent((int)1000, rl -> rl.toString().equals("minecraft:loot_table/chests/woodland_mansion"), (String)"Distribute Globe banner pattern to woodland mansion chest", context -> {
            JsonElement pool = JsonParser.parseString((String)"{\n  \"rolls\": 1.0,\n  \"entries\": [\n    {\n      \"type\": \"minecraft:item\",\n      \"name\": \"minecraft:globe_banner_pattern\"\n    }\n  ],\n  \"conditions\": [\n    {\n      \"condition\": \"minecraft:random_chance\"\n    }\n  ]\n}\n").deepCopy();
            pool.getAsJsonObject().getAsJsonArray("conditions").get(0).getAsJsonObject().addProperty("chance", (Number)1.0);
            ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonArray("pools").add(pool);
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]);
        Mixson.registerEvent((int)1000, rl -> rl.toString().equals("minecraft:loot_table/chests/pillager_outpost"), (String)"Distribute woodland explorer map to pillager outpost chest", context -> {
            JsonElement pool = JsonParser.parseString((String)"{\n  \"rolls\": 1.0,\n  \"entries\": [\n    {\n      \"type\": \"minecraft:item\",\n      \"functions\": [\n        {\n          \"function\": \"minecraft:exploration_map\",\n          \"destination\": \"minecraft:on_woodland_explorer_maps\",\n          \"decoration\": \"minecraft:mansion\",\n          \"zoom\": 2\n        },\n        {\n          \"function\": \"minecraft:set_name\",\n          \"name\": {\n            \"translate\": \"filled_map.mansion\"\n          },\n          \"target\": \"item_name\"\n        }\n      ],\n      \"name\": \"minecraft:map\"\n    }\n  ],\n  \"conditions\": [\n    {\n      \"condition\": \"minecraft:random_chance\"\n    }\n  ]\n}\n").deepCopy();
            pool.getAsJsonObject().getAsJsonArray("conditions").get(0).getAsJsonObject().addProperty("chance", (Number)0.33);
            ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonArray("pools").add(pool);
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]);
        Mixson.registerEvent((int)1000, rl -> rl.toString().equals("minecraft:loot_table/chests/shipwreck_map"), (String)"Distribute ocean explorer map to shipwreck map chest", context -> {
            JsonElement pool = JsonParser.parseString((String)"{\n  \"rolls\": 1,\n  \"entries\": [\n    {\n      \"type\": \"minecraft:item\",\n      \"functions\": [\n        {\n          \"function\": \"minecraft:exploration_map\",\n          \"destination\": \"minecraft:on_ocean_explorer_maps\",\n          \"decoration\": \"minecraft:monument\",\n          \"zoom\": 2\n        },\n        {\n          \"function\": \"minecraft:set_name\",\n          \"name\": {\n            \"translate\": \"filled_map.monument\"\n          },\n          \"target\": \"item_name\"\n        }\n      ],\n      \"name\": \"minecraft:map\"\n    }\n  ],\n  \"conditions\": [\n    {\n      \"condition\": \"minecraft:random_chance\"\n    }\n  ]\n}\n").deepCopy();
            pool.getAsJsonObject().getAsJsonArray("conditions").get(0).getAsJsonObject().addProperty("chance", (Number)0.5);
            ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonArray("pools").add(pool);
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]);
        LootValues.TOTEM_LOCATION_CHANCE.forEach((key, value) -> Mixson.registerEvent((int)1000, rl -> rl.toString().equals("minecraft:loot_table/chests/" + key), (String)"Distribute Totem of Undying to loot chests", context -> {
            JsonElement pool = JsonParser.parseString((String)"{\n  \"rolls\": 1.0,\n  \"entries\": [\n    {\n      \"type\": \"minecraft:item\"\n    }\n  ],\n  \"conditions\": [\n    {\n      \"condition\": \"minecraft:random_chance\"\n    }\n  ]\n}\n").deepCopy();
            pool.getAsJsonObject().getAsJsonArray("entries").get(0).getAsJsonObject().addProperty("name", "minecraft:totem_of_undying");
            pool.getAsJsonObject().getAsJsonArray("conditions").get(0).getAsJsonObject().addProperty("chance", (Number)value);
            ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonArray("pools").add(pool);
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]));
        Mixson.registerEvent((int)1000, rl -> rl.toString().equals("minecraft:loot_table/chests/desert_pyramid"), (String)"Distribute curse enchantments to desert pyramid chests", context -> {
            JsonElement pool = JsonParser.parseString((String)"{\n  \"rolls\": 1,\n  \"entries\": [\n    {\n      \"type\": \"minecraft:item\",\n      \"name\": \"minecraft:book\",\n      \"functions\": [\n        {\n          \"function\": \"minecraft:enchant_randomly\",\n          \"options\": \"#minecraft:curse\"\n        }\n      ]\n    }\n  ],\n  \"conditions\": [\n    {\n      \"condition\": \"minecraft:random_chance\"\n    }\n  ]\n}\n").deepCopy();
            pool.getAsJsonObject().getAsJsonArray("conditions").get(0).getAsJsonObject().addProperty("chance", (Number)0.5);
            ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonArray("pools").add(pool);
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]);
        Mixson.registerEvent((int)1000, rl -> rl.toString().equals("minecraft:loot_table/chests/igloo_chest") || rl.toString().equals("minecraft:loot_table/chests/ancient_city_ice_box"), (String)"Distribute frost walker enchantment to igloo and ice box chests", context -> {
            JsonElement pool = JsonParser.parseString((String)"{\n  \"rolls\": 1,\n  \"entries\": [\n    {\n      \"type\": \"minecraft:item\",\n      \"name\": \"minecraft:book\",\n      \"functions\": [\n        {\n          \"function\": \"minecraft:enchant_randomly\",\n          \"options\": \"minecraft:frost_walker\"\n        }\n      ]\n    }\n  ],\n  \"conditions\": [\n    {\n      \"condition\": \"minecraft:random_chance\"\n    }\n  ]\n}\n").deepCopy();
            pool.getAsJsonObject().getAsJsonArray("conditions").get(0).getAsJsonObject().addProperty("chance", (Number)(context.getResourceId().method_12832().endsWith("igloo_chest.json") ? 0.5 : 1.0));
            ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonArray("pools").add(pool);
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]);
        Mixson.registerEvent((int)1000, rl -> rl.toString().equals("minecraft:loot_table/entities/elder_guardian"), (String)"Distribute trident enchantments to elder guardian drops", context -> {
            JsonElement pool = JsonParser.parseString((String)"{\n  \"rolls\": 1,\n  \"entries\": [\n    {\n      \"type\": \"minecraft:item\",\n      \"name\": \"minecraft:book\",\n      \"functions\": [\n        {\n          \"function\": \"minecraft:enchant_randomly\",\n          \"options\": [\n             \"minecraft:loyalty\",\n             \"minecraft:riptide\",\n             \"minecraft:impaling\",\n             \"minecraft:channeling\"\n          ]\n        }\n      ]\n    }\n  ]\n}\n").deepCopy();
            ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonArray("pools").add(pool);
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]);
        Mixson.registerEvent((int)1000, rl -> rl.toString().equals("minecraft:loot_table/chests/trial_chambers/reward_ominous"), (String)"Distribute mace enchantments to trial chamber rewards", context -> {
            JsonElement pool = JsonParser.parseString((String)"{\n  \"rolls\": 1,\n  \"entries\": [\n    {\n      \"type\": \"minecraft:item\",\n      \"name\": \"minecraft:book\",\n      \"functions\": [\n        {\n          \"function\": \"minecraft:enchant_randomly\",\n          \"options\": [\n             \"minecraft:density\",\n             \"minecraft:breach\"\n          ]\n        }\n      ]\n    }\n  ]\n}\n").deepCopy();
            ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonArray("pools").add(pool);
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]);
        Mixson.registerEvent((int)1000, rl -> rl.toString().equals("minecraft:loot_table/blocks/oak_leaves") || rl.toString().equals("minecraft:loot_table/blocks/dark_oak_leaves"), (String)"Increase apple drop chance", context -> {
            JsonArray pools = ((JsonElement)context.getFile()).getAsJsonObject().getAsJsonArray("pools");
            for (JsonElement pool : pools) {
                JsonArray updatedEntries = new JsonArray();
                JsonArray entries = pool.getAsJsonObject().getAsJsonArray("entries");
                for (JsonElement entry : entries) {
                    if (!entry.getAsJsonObject().has("name") || !entry.getAsJsonObject().get("name").getAsString().equals("minecraft:apple")) continue;
                    updatedEntries = entries.deepCopy();
                    updatedEntries.remove(entry);
                    JsonElement e = JsonParser.parseString((String)"{\n  \"type\": \"minecraft:item\",\n  \"name\": \"minecraft:apple\",\n  \"conditions\": [\n    {\n      \"condition\": \"minecraft:random_chance\"\n    }\n  ]\n}\n").deepCopy();
                    e.getAsJsonObject().getAsJsonArray("conditions").get(0).getAsJsonObject().addProperty("chance", (Number)0.025);
                    updatedEntries.add(e);
                    break;
                }
                if (updatedEntries.isEmpty()) continue;
                pool.getAsJsonObject().add("entries", (JsonElement)updatedEntries);
                break;
            }
        }, (boolean)true, (ResourceReference[])new ResourceReference[0]);
    }
}

