/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.anvillib.ae2.impl;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.util.AECableType;
import appeng.me.GridAccessException;
import appeng.me.helpers.IGridProxyable;
import net.anvilcraft.anvillib.ae2.AEIntegration;
import net.anvilcraft.anvillib.api.units.IEnergyAdapter;
import net.anvilcraft.anvillib.api.units.IEnergyUnit;
import net.anvilcraft.anvillib.energy.BaseEnergyAdapter;
import net.minecraftforge.common.util.ForgeDirection;

public class AEEnergyAdapter
extends BaseEnergyAdapter {
    @Override
    public IEnergyUnit getDefaultUnit() {
        return AEIntegration.ENERGY_UNIT;
    }

    @Override
    public Class<?>[] getRelatedInterfaces() {
        return new Class[]{IGridProxyable.class, IEnergyGrid.class, IEnergySource.class, IAEPowerStorage.class, IGridHost.class};
    }

    @Override
    public boolean canConnect(Object obj, ForgeDirection from, Object source, int energyFlowFlags) {
        return obj instanceof IGridHost ? ((IGridHost)obj).getCableConnectionType(from) != AECableType.NONE : false;
    }

    @Override
    public double receiveEnergy(Object obj, ForgeDirection from, double receive, boolean doReceive) {
        if (obj instanceof IAEPowerStorage) {
            return receive - ((IAEPowerStorage)obj).injectAEPower(receive, doReceive ? Actionable.MODULATE : Actionable.SIMULATE);
        }
        IEnergyGrid grid = this.getGrid(obj, from);
        if (grid != null) {
            double overflow = grid.injectPower(receive, doReceive ? Actionable.MODULATE : Actionable.SIMULATE);
            return doReceive ? receive : receive - overflow;
        }
        return 0.0;
    }

    @Override
    public double extractEnergy(Object obj, ForgeDirection from, double extract, boolean doExtract) {
        IEnergySource src;
        Object object = src = obj instanceof IEnergySource ? (IEnergySource)obj : this.getGrid(obj, from);
        return src != null ? src.extractAEPower(extract, doExtract ? Actionable.MODULATE : Actionable.SIMULATE, PowerMultiplier.ONE) : 0.0;
    }

    @Override
    public double getEnergy(Object obj, ForgeDirection from) {
        if (obj instanceof IAEPowerStorage) {
            return ((IAEPowerStorage)obj).getAECurrentPower();
        }
        IEnergyGrid grid = this.getGrid(obj, from);
        return grid != null ? grid.getStoredPower() : 0.0;
    }

    @Override
    public double getEnergyCapacity(Object obj, ForgeDirection from) {
        if (obj instanceof IAEPowerStorage) {
            return ((IAEPowerStorage)obj).getAEMaxPower();
        }
        IEnergyGrid grid = this.getGrid(obj, from);
        return grid != null ? grid.getMaxStoredPower() : 0.0;
    }

    private IEnergyGrid getGrid(Object obj, ForgeDirection from) {
        IEnergyGrid grid = null;
        if (obj instanceof IEnergyGrid) {
            grid = (IEnergyGrid)obj;
        } else if (obj instanceof IGridProxyable) {
            try {
                grid = ((IGridProxyable)obj).getProxy().getEnergy();
            }
            catch (GridAccessException gridAccessException) {}
        } else if (obj instanceof IGridHost && ((IGridHost)obj).getGridNode(from) != null) {
            IGridNode node = ((IGridHost)obj).getGridNode(from);
            grid = (IEnergyGrid)node.getGrid().getCache(IEnergyGrid.class);
        }
        return grid;
    }

    @Override
    public <T> T createWrapper(Object source, Class<T> iface, IEnergyAdapter sourceAdapter) {
        if (IAEPowerStorage.class.isAssignableFrom(iface)) {
            return (T)new Wrapper(sourceAdapter, source);
        }
        return null;
    }

    private class Wrapper
    implements IAEPowerStorage {
        IEnergyAdapter system;
        Object obj;

        public Wrapper(IEnergyAdapter system, Object obj) {
            this.system = system;
            this.obj = obj;
        }

        public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
            return this.system.extractEnergy(this.obj, AEEnergyAdapter.this.getDefaultUnit(), ForgeDirection.UNKNOWN, amt, mode == Actionable.MODULATE);
        }

        public double injectAEPower(double amt, Actionable mode) {
            return amt - this.system.receiveEnergy(this.obj, AEEnergyAdapter.this.getDefaultUnit(), ForgeDirection.UNKNOWN, amt, mode == Actionable.MODULATE);
        }

        public double getAEMaxPower() {
            return this.system.getEnergy(this.obj, AEEnergyAdapter.this.getDefaultUnit(), ForgeDirection.UNKNOWN);
        }

        public double getAECurrentPower() {
            return this.system.getEnergyCapacity(this.obj, AEEnergyAdapter.this.getDefaultUnit(), ForgeDirection.UNKNOWN);
        }

        public boolean isAEPublicPowerStorage() {
            return false;
        }

        public AccessRestriction getPowerFlow() {
            return AccessRestriction.READ_WRITE;
        }
    }
}

