/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.anvillib.ae2.impl;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.anvilcraft.anvillib.ae2.impl.StackIterator;

public final class AEItemList<T extends IAEStack<T>>
implements IItemList<T> {
    private final Map<T, T> records = new HashMap<T, T>();

    public void add(T option) {
        if (option == null) {
            return;
        }
        T st = this.getFluidRecord(option);
        if (st != null) {
            st.add(option);
            return;
        }
        IAEStack opt = option.copy();
        this.putFluidRecord(opt);
    }

    public T findPrecise(T fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        return this.getFluidRecord(fluidStack);
    }

    public Collection<T> findFuzzy(T filter, FuzzyMode fuzzy) {
        if (filter == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.findPrecise(filter));
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public void addStorage(T option) {
        if (option == null) {
            return;
        }
        T st = this.getFluidRecord(option);
        if (st != null) {
            st.incStackSize(option.getStackSize());
            return;
        }
        IAEStack opt = option.copy();
        this.putFluidRecord(opt);
    }

    public void addCrafting(T option) {
        if (option == null) {
            return;
        }
        T st = this.getFluidRecord(option);
        if (st != null) {
            st.setCraftable(true);
            return;
        }
        IAEStack opt = option.copy();
        opt.setStackSize(0L);
        opt.setCraftable(true);
        this.putFluidRecord(opt);
    }

    public void addRequestable(T option) {
        if (option == null) {
            return;
        }
        T st = this.getFluidRecord(option);
        if (st != null) {
            st.setCountRequestable(st.getCountRequestable() + option.getCountRequestable());
            return;
        }
        IAEStack opt = option.copy();
        opt.setStackSize(0L);
        opt.setCraftable(false);
        opt.setCountRequestable(option.getCountRequestable());
        this.putFluidRecord(opt);
    }

    public T getFirstItem() {
        Iterator<T> iterator = this.iterator();
        if (iterator.hasNext()) {
            IAEStack stackType = (IAEStack)iterator.next();
            return (T)stackType;
        }
        return null;
    }

    public int size() {
        return this.records.values().size();
    }

    public Iterator<T> iterator() {
        return new StackIterator<T>(this.records.values().iterator());
    }

    public void resetStatus() {
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            IAEStack i = (IAEStack)iterator.next();
            i.reset();
        }
    }

    private T getFluidRecord(T fluid) {
        return (T)((IAEStack)this.records.get(fluid));
    }

    private T putFluidRecord(T fluid) {
        return (T)((IAEStack)this.records.put(fluid, fluid));
    }
}

