/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.anvillib.ae2.impl;

import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.function.Function;
import net.anvilcraft.anvillib.ae2.impl.AEItemList;
import net.minecraft.nbt.NBTTagCompound;

public abstract class BaseStorageChannel<T extends IAEStack<T>>
implements IStorageChannel<T> {
    private Class<T> type;
    private Function<Object, T> factory;
    private Function<ByteBuf, T> packetReader;
    private Function<NBTTagCompound, T> nbtReader;

    public BaseStorageChannel(Class<T> type, Function<Object, T> factory, Function<ByteBuf, T> packetReader, Function<NBTTagCompound, T> nbtReader) {
        this.type = type;
        this.factory = factory;
        this.packetReader = packetReader;
        this.nbtReader = nbtReader;
    }

    public Class<T> getType() {
        return this.type;
    }

    public IItemList<T> createList() {
        return new AEItemList();
    }

    public T createStack(Object input) {
        if (input == null) {
            return null;
        }
        if (this.type.isAssignableFrom(input.getClass())) {
            return (T)((IAEStack)input).copy();
        }
        if (this.factory != null) {
            return (T)((IAEStack)this.factory.apply(input));
        }
        return null;
    }

    public T readFromPacket(ByteBuf input) throws IOException {
        return (T)((IAEStack)this.packetReader.apply(input));
    }

    public T createFromNBT(NBTTagCompound nbt) {
        return (T)((IAEStack)this.nbtReader.apply(nbt));
    }
}

