/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.anvillib.ae2.impl;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAETagCompound;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.anvilcraft.anvillib.api.ae2.stack.IByteStack;
import net.minecraft.nbt.NBTTagCompound;

public class ByteStack
implements IByteStack {
    private UUID address;
    private UUID diskId = null;
    private byte[] bytes = new byte[0];

    public ByteStack(UUID address) {
        this.address = address;
    }

    public void add(IByteStack is) {
        if (!this.address.equals(is.getAddress())) {
            return;
        }
        int newSize = this.bytes.length + is.getBytes().length;
        byte[] array = Arrays.copyOf(this.bytes, newSize);
        System.arraycopy(is.getBytes(), 0, array, this.bytes.length, is.getBytes().length);
    }

    public long getStackSize() {
        return this.bytes.length;
    }

    public IByteStack setStackSize(long stackSize) {
        return this;
    }

    public long getCountRequestable() {
        return 0L;
    }

    public IByteStack setCountRequestable(long countRequestable) {
        return this;
    }

    public boolean isCraftable() {
        return false;
    }

    public IByteStack setCraftable(boolean isCraftable) {
        return this;
    }

    public IByteStack reset() {
        this.diskId = null;
        this.bytes = new byte[0];
        return this;
    }

    public boolean isMeaningful() {
        return true;
    }

    public void incStackSize(long i) {
    }

    public void decStackSize(long i) {
    }

    public void incCountRequestable(long i) {
    }

    public void decCountRequestable(long i) {
    }

    public void writeToNBT(NBTTagCompound i) {
        i.func_74778_a("address", this.address.toString());
        i.func_74773_a("bytes", this.bytes);
        if (this.diskId != null) {
            i.func_74778_a("diskId", this.diskId.toString());
        }
    }

    public boolean fuzzyComparison(Object st, FuzzyMode mode) {
        if (st instanceof IByteStack) {
            IByteStack other = (IByteStack)st;
            return this.getAddress() == other.getAddress() && (this.getDiskId() == null || other.getDiskId() == null || this.getDiskId().equals(other.getDiskId()));
        }
        return false;
    }

    public void writeToPacket(ByteBuf data) throws IOException {
        throw new UnsupportedOperationException("Unimplemented method 'writeToPacket'");
    }

    public IByteStack copy() {
        ByteStack stack = new ByteStack(this.address);
        stack.setDiskId(this.diskId);
        stack.setBytes((byte[])this.bytes.clone());
        return stack;
    }

    public IByteStack empty() {
        return new ByteStack(this.address);
    }

    public IAETagCompound getTagCompound() {
        return null;
    }

    public boolean isItem() {
        return false;
    }

    public boolean isFluid() {
        return false;
    }

    public IStorageChannel<?> getStorageChannel() {
        throw new UnsupportedOperationException("Unimplemented method 'getStorageChannel'");
    }

    @Override
    public UUID getDiskId() {
        return this.diskId;
    }

    @Override
    public void setDiskId(UUID diskId) {
        this.diskId = diskId;
    }

    @Override
    public UUID getAddress() {
        return this.address;
    }

    @Override
    public byte[] getBytes() {
        return (byte[])this.bytes.clone();
    }

    @Override
    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public Stream<Byte> getByteStream() {
        return IntStream.range(0, this.bytes.length).mapToObj(i -> this.bytes[i]);
    }

    @Override
    public InputStream read() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public void write(Consumer<OutputStream> writer) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        writer.accept(stream);
        this.bytes = stream.toByteArray();
    }
}

