/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.anvillib.ae2.impl;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IAETagCompound;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.anvilcraft.anvillib.ae2.AEIntegration;
import net.anvilcraft.anvillib.ae2.impl.BaseStack;
import net.anvilcraft.anvillib.api.ae2.channel.IEnergyStorageChannel;
import net.anvilcraft.anvillib.api.ae2.stack.IEnergyStack;
import net.anvilcraft.anvillib.api.units.IEnergyUnit;
import net.anvilcraft.anvillib.registries.UnitRegistry;
import net.anvilcraft.anvillib.util.AnvilUtil;
import net.minecraft.nbt.NBTTagCompound;

public class EnergyStack
extends BaseStack<IEnergyStack>
implements IEnergyStack {
    private double amount = 0.0;
    private IEnergyUnit type;

    public EnergyStack(IEnergyUnit type) {
        super(AEApi.instance().storage().getStorageChannel(IEnergyStorageChannel.class));
        this.type = type;
    }

    public void add(IEnergyStack is) {
        if (is == null) {
            return;
        }
        this.amount += is.getEnergy();
        this.setCountRequestable(this.getCountRequestable() + is.getCountRequestable());
        this.setCraftable(this.isCraftable() || is.isCraftable());
    }

    public long getStackSize() {
        return (long)this.amount;
    }

    public IEnergyStack setStackSize(long stackSize) {
        this.amount = stackSize;
        return this;
    }

    public IEnergyStack reset() {
        this.amount = 0.0;
        this.isCraftable = false;
        this.requestable = 0L;
        return this;
    }

    @Override
    public boolean isMeaningful() {
        return this.amount != 0.0 || this.requestable > 0L || this.isCraftable;
    }

    public static IEnergyStack readFromNBT(NBTTagCompound i) {
        if (!i.func_74764_b("type")) {
            return null;
        }
        String typeId = i.func_74779_i("type");
        IEnergyUnit type = (IEnergyUnit)UnitRegistry.INSTANCE.get(typeId);
        EnergyStack stack = new EnergyStack(type);
        stack.setCraftable(i.func_74767_n("isCraftable"));
        stack.setEnergy(i.func_74769_h("amount"));
        stack.setCountRequestable(i.func_74763_f("requestable"));
        return stack;
    }

    public void writeToNBT(NBTTagCompound i) {
        i.func_74757_a("isCraftable", this.isCraftable);
        i.func_74780_a("amount", this.amount);
        i.func_74772_a("requestable", this.requestable);
        i.func_74778_a("type", this.type.getID());
    }

    public boolean fuzzyComparison(Object st, FuzzyMode mode) {
        if (st instanceof IEnergyStack) {
            return this.getEnergyType() == ((IEnergyStack)st).getEnergyType();
        }
        if (st instanceof IEnergyUnit) {
            return this.getEnergyType() == st;
        }
        return false;
    }

    public static IEnergyStack readFromPacket(ByteBuf data) {
        String typeId = AnvilUtil.readStringFromPacket(data);
        IEnergyUnit system = (IEnergyUnit)UnitRegistry.INSTANCE.get(typeId);
        EnergyStack stack = new EnergyStack(system);
        stack.setEnergy(data.readDouble());
        stack.setCraftable(data.readBoolean());
        stack.setCountRequestable(data.readLong());
        return stack;
    }

    public void writeToPacket(ByteBuf data) throws IOException {
        AnvilUtil.writeStringToPacket(this.type.getID(), data);
        data.writeDouble(this.amount);
        data.writeBoolean(this.isCraftable);
        data.writeLong(this.requestable);
    }

    public IEnergyStack copy() {
        EnergyStack stack = new EnergyStack(this.type);
        stack.setEnergy(this.getEnergy());
        stack.setCraftable(this.isCraftable());
        stack.setCountRequestable(this.getCountRequestable());
        return stack;
    }

    public IAETagCompound getTagCompound() {
        return null;
    }

    @Override
    public double getEnergy() {
        return this.amount;
    }

    @Override
    public void setEnergy(double energy) {
        this.amount = energy;
    }

    @Override
    public double getAsAE() {
        return this.getEnergyType().convertTo(AEIntegration.ENERGY_UNIT, this.amount);
    }

    @Override
    public IEnergyUnit getEnergyType() {
        return this.type;
    }
}

