/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.anvillib.ae2.impl;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAETagCompound;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.anvilcraft.anvillib.api.ae2.channel.IItemResearchStorageChannel;
import net.anvilcraft.anvillib.api.ae2.stack.IItemResearchStack;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ItemResearchStack
implements IItemResearchStack {
    private IItemResearchStorageChannel channel = (IItemResearchStorageChannel)AEApi.instance().storage().getStorageChannel(IItemResearchStorageChannel.class);
    private IAEItemStack item;
    private double researchProgress = 0.0;

    public ItemResearchStack(IAEItemStack item) {
        this.item = (IAEItemStack)item.empty();
        this.item.setStackSize(1L);
    }

    public void add(IItemResearchStack is) {
        if (this.isSameType(is)) {
            this.researchProgress = Math.max(this.getResearchProgress(), is.getResearchProgress());
        }
    }

    public long getStackSize() {
        return this.researchProgress == 0.0 ? 0L : 1L;
    }

    public IItemResearchStack setStackSize(long stackSize) {
        return this;
    }

    public long getCountRequestable() {
        return 0L;
    }

    public IItemResearchStack setCountRequestable(long countRequestable) {
        return this;
    }

    public boolean isCraftable() {
        return false;
    }

    public IItemResearchStack setCraftable(boolean isCraftable) {
        return this;
    }

    public IItemResearchStack reset() {
        this.researchProgress = 0.0;
        return this;
    }

    public boolean isMeaningful() {
        return this.researchProgress > 0.0;
    }

    public void incStackSize(long i) {
    }

    public void decStackSize(long i) {
    }

    public void incCountRequestable(long i) {
    }

    public void decCountRequestable(long i) {
    }

    public static IItemResearchStack readFromNBT(NBTTagCompound i) {
        NBTTagCompound it = i.func_74775_l("item");
        IAEItemStack item = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createFromNBT(it);
        ItemResearchStack stack = new ItemResearchStack(item);
        stack.setResearchProgress(i.func_74769_h("researchProgress"));
        return stack;
    }

    public void writeToNBT(NBTTagCompound i) {
        NBTTagCompound item = new NBTTagCompound();
        this.item.writeToNBT(item);
        i.func_74782_a("item", (NBTBase)item);
        i.func_74780_a("researchProgress", this.researchProgress);
    }

    public boolean fuzzyComparison(Object st, FuzzyMode mode) {
        return this.item.fuzzyComparison(st, mode);
    }

    public static IItemResearchStack readFromPacket(ByteBuf data) {
        int length = data.readInt();
        byte[] bytes = new byte[length];
        data.readBytes(bytes);
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            NBTTagCompound nbt = CompressedStreamTools.func_74794_a((DataInputStream)inputStream);
            return ItemResearchStack.readFromNBT(nbt);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void writeToPacket(ByteBuf data) throws IOException {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(byteOutputStream);
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        CompressedStreamTools.func_74800_a((NBTTagCompound)nbt, (DataOutput)outputStream);
        byte[] bytes = byteOutputStream.toByteArray();
        int length = bytes.length;
        data.writeInt(length);
        data.writeBytes(bytes);
    }

    public IItemResearchStack copy() {
        ItemResearchStack stack = new ItemResearchStack(this.item);
        stack.setResearchProgress(this.researchProgress);
        return stack;
    }

    public IItemResearchStack empty() {
        return (IItemResearchStack)this.copy().reset();
    }

    public IAETagCompound getTagCompound() {
        return this.item.getTagCompound();
    }

    public IStorageChannel<?> getStorageChannel() {
        return this.channel;
    }

    @Override
    public double getResearchProgress() {
        return this.researchProgress;
    }

    @Override
    public void setResearchProgress(double researchProgress) {
        this.researchProgress = researchProgress;
    }

    @Override
    public IAEItemStack getItemStack() {
        return this.item.copy();
    }

    @Override
    public Item getItem() {
        return this.item.getItem();
    }

    @Override
    public int getItemDamage() {
        return this.item.getItemDamage();
    }

    @Override
    public boolean isSameType(IItemResearchStack stack) {
        return stack.isSameType(this.item);
    }

    @Override
    public boolean isSameType(IAEItemStack otherStack) {
        return this.item.isSameType(otherStack);
    }

    @Override
    public boolean isSameType(ItemStack stored) {
        return this.item.isSameType(stored);
    }
}

