/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.anvillib.ae2.impl;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IAETagCompound;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.anvilcraft.anvillib.ae2.impl.BaseStack;
import net.anvilcraft.anvillib.api.ae2.channel.IManaStorageChannel;
import net.anvilcraft.anvillib.api.ae2.stack.IManaStack;
import net.anvilcraft.anvillib.api.units.IUnit;
import net.anvilcraft.anvillib.registries.UnitRegistry;
import net.anvilcraft.anvillib.util.AnvilUtil;
import net.minecraft.nbt.NBTTagCompound;

public class ManaStack
extends BaseStack<IManaStack>
implements IManaStack {
    private long amount = 0L;
    private IUnit type;

    public ManaStack(IUnit type) {
        super(AEApi.instance().storage().getStorageChannel(IManaStorageChannel.class));
        this.type = type;
    }

    public void add(IManaStack is) {
        if (is == null) {
            return;
        }
        this.amount += is.getStackSize();
        this.setCountRequestable(this.getCountRequestable() + is.getCountRequestable());
        this.setCraftable(this.isCraftable() || is.isCraftable());
    }

    public long getStackSize() {
        return this.amount;
    }

    public IManaStack setStackSize(long stackSize) {
        this.amount = stackSize;
        return this;
    }

    public IManaStack reset() {
        this.amount = 0L;
        this.isCraftable = false;
        this.requestable = 0L;
        return this;
    }

    public static IManaStack readFromNBT(NBTTagCompound i) {
        if (!i.func_74764_b("type")) {
            return null;
        }
        String typeId = i.func_74779_i("type");
        IUnit type = UnitRegistry.INSTANCE.get(typeId);
        ManaStack stack = new ManaStack(type);
        stack.setCraftable(i.func_74767_n("isCraftable"));
        stack.setStackSize(i.func_74763_f("amount"));
        stack.setCountRequestable(i.func_74763_f("requestable"));
        return stack;
    }

    public void writeToNBT(NBTTagCompound i) {
        i.func_74757_a("isCraftable", this.isCraftable);
        i.func_74772_a("amount", this.amount);
        i.func_74772_a("requestable", this.requestable);
        i.func_74778_a("type", this.type.getID());
    }

    public boolean fuzzyComparison(Object st, FuzzyMode mode) {
        if (st instanceof IManaStack) {
            return this.getManaType() == ((IManaStack)st).getManaType();
        }
        if (st instanceof IUnit) {
            return this.getManaType() == st;
        }
        return false;
    }

    public static IManaStack readFromPacket(ByteBuf data) {
        String typeId = AnvilUtil.readStringFromPacket(data);
        IUnit system = UnitRegistry.INSTANCE.get(typeId);
        ManaStack stack = new ManaStack(system);
        stack.setStackSize(data.readLong());
        stack.setCraftable(data.readBoolean());
        stack.setCountRequestable(data.readLong());
        return stack;
    }

    public void writeToPacket(ByteBuf data) throws IOException {
        AnvilUtil.writeStringToPacket(this.type.getID(), data);
        data.writeLong(this.amount);
        data.writeBoolean(this.isCraftable);
        data.writeLong(this.requestable);
    }

    public IManaStack copy() {
        ManaStack stack = new ManaStack(this.type);
        stack.setStackSize(this.getStackSize());
        stack.setCraftable(this.isCraftable());
        stack.setCountRequestable(this.getCountRequestable());
        return stack;
    }

    public IAETagCompound getTagCompound() {
        return null;
    }

    @Override
    public IUnit getManaType() {
        return this.type;
    }
}

