/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.anvillib.energy;

import net.anvilcraft.anvillib.api.units.IEnergyAdapter;
import net.anvilcraft.anvillib.api.units.IEnergyUnit;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BaseEnergyAdapter
implements IEnergyAdapter {
    protected abstract double receiveEnergy(Object var1, ForgeDirection var2, double var3, boolean var5);

    protected abstract double extractEnergy(Object var1, ForgeDirection var2, double var3, boolean var5);

    protected abstract double getEnergy(Object var1, ForgeDirection var2);

    protected abstract double getEnergyCapacity(Object var1, ForgeDirection var2);

    protected boolean setEnergy(Object obj, ForgeDirection from, double energy) {
        double delta = energy - this.getEnergy(obj, from);
        if (delta > 0.0) {
            return delta == this.receiveEnergy(obj, from, delta, true);
        }
        if (delta < 0.0) {
            return -delta == this.extractEnergy(obj, from, -delta, true);
        }
        return delta == 0.0;
    }

    @Override
    public boolean canHandle(Class<?> type) {
        for (Class<?> t : this.getRelatedInterfaces()) {
            if (!t.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canHandle(Object obj) {
        return obj != null ? this.canHandle(obj.getClass()) : false;
    }

    @Override
    public double extractEnergy(Object obj, IEnergyUnit unit, ForgeDirection from, double extract, boolean doExtract) {
        return this.getDefaultUnit().convertTo(unit, this.extractEnergy(obj, from, unit.convertTo(this.getDefaultUnit(), extract), doExtract));
    }

    @Override
    public double getEnergy(Object obj, IEnergyUnit unit, ForgeDirection from) {
        return this.getDefaultUnit().convertTo(unit, this.getEnergy(obj, from));
    }

    @Override
    public double getEnergyCapacity(Object obj, IEnergyUnit unit, ForgeDirection from) {
        return this.getDefaultUnit().convertTo(unit, this.getEnergyCapacity(obj, from));
    }

    @Override
    public double receiveEnergy(Object obj, IEnergyUnit unit, ForgeDirection from, double receive, boolean doReceive) {
        return this.getDefaultUnit().convertTo(unit, this.receiveEnergy(obj, from, unit.convertTo(this.getDefaultUnit(), receive), doReceive));
    }

    @Override
    public boolean setEnergy(Object obj, IEnergyUnit unit, ForgeDirection from, double energy) {
        return this.setEnergy(obj, from, unit.convertTo(this.getDefaultUnit(), energy));
    }
}

