/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.anvillib.energy;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import net.anvilcraft.anvillib.api.units.IEnergyAdapter;
import net.anvilcraft.anvillib.api.units.IEnergyUnit;
import net.anvilcraft.anvillib.energy.BaseEnergyAdapter;
import net.anvilcraft.anvillib.energy.RFEnergyUnit;
import net.minecraftforge.common.util.ForgeDirection;

public class RFEnergyAdapter
extends BaseEnergyAdapter {
    RFEnergyUnit unit;

    public RFEnergyAdapter(RFEnergyUnit unit) {
        this.unit = unit;
    }

    @Override
    public IEnergyUnit getDefaultUnit() {
        return this.unit;
    }

    @Override
    public Class<?>[] getRelatedInterfaces() {
        return new Class[]{IEnergyHandler.class, IEnergyReceiver.class, IEnergyProvider.class};
    }

    @Override
    public boolean canConnect(Object obj, ForgeDirection from, Object source, int energyFlowFlags) {
        boolean requireOutput;
        boolean requireInput = (energyFlowFlags & 1) == 1;
        boolean bl = requireOutput = (energyFlowFlags & 2) == 2;
        return obj instanceof IEnergyConnection ? !(!((IEnergyConnection)obj).canConnectEnergy(from) || requireInput && !(obj instanceof IEnergyReceiver) || requireOutput && !(obj instanceof IEnergyProvider)) : false;
    }

    @Override
    public double receiveEnergy(Object obj, ForgeDirection from, double receive, boolean doReceive) {
        if (obj instanceof IEnergyReceiver) {
            return ((IEnergyReceiver)obj).receiveEnergy(from, (int)receive, !doReceive);
        }
        return 0.0;
    }

    @Override
    public double extractEnergy(Object obj, ForgeDirection from, double extract, boolean doExtract) {
        if (obj instanceof IEnergyProvider) {
            return ((IEnergyProvider)obj).extractEnergy(from, (int)extract, !doExtract);
        }
        return 0.0;
    }

    @Override
    public double getEnergy(Object obj, ForgeDirection from) {
        if (obj instanceof IEnergyHandler) {
            return ((IEnergyHandler)obj).getEnergyStored(from);
        }
        return 0.0;
    }

    @Override
    public double getEnergyCapacity(Object obj, ForgeDirection from) {
        if (obj instanceof IEnergyHandler) {
            return ((IEnergyHandler)obj).getMaxEnergyStored(from);
        }
        return 0.0;
    }

    @Override
    public <T> T createWrapper(Object source, Class<T> iface, IEnergyAdapter sourceSystem) {
        if (IEnergyReceiver.class.isAssignableFrom(iface) || IEnergyProvider.class.isAssignableFrom(iface)) {
            return (T)new Wrapper(sourceSystem, source);
        }
        return null;
    }

    private class Wrapper
    implements IEnergyHandler {
        private IEnergyAdapter adapter;
        private Object obj;

        public Wrapper(IEnergyAdapter adapter, Object obj) {
            this.adapter = adapter;
            this.obj = obj;
        }

        @Override
        public boolean canConnectEnergy(ForgeDirection var1) {
            return this.adapter.canConnect(this.obj, var1, this, 0);
        }

        @Override
        public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
            return (int)this.adapter.receiveEnergy(this.obj, RFEnergyAdapter.this.unit, from, maxReceive, !simulate);
        }

        @Override
        public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
            return (int)this.adapter.extractEnergy(this.obj, RFEnergyAdapter.this.unit, from, maxExtract, !simulate);
        }

        @Override
        public int getEnergyStored(ForgeDirection from) {
            return (int)this.adapter.getEnergy(this.obj, RFEnergyAdapter.this.unit, from);
        }

        @Override
        public int getMaxEnergyStored(ForgeDirection from) {
            return (int)this.adapter.getEnergyCapacity(this.obj, RFEnergyAdapter.this.unit, from);
        }
    }
}

