/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.anvillib.garbagecollection;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.anvilcraft.anvillib.garbagecollection.GCPredicate;
import net.anvilcraft.anvillib.garbagecollection.GarbageCollector;

public class GCManager {
    public static GCManager INSTANCE = new GCManager();
    private Set<GCEntry> maps = new HashSet<GCEntry>();
    private GarbageCollector<GCEntry> collector = null;

    public <K, V> Map<K, V> createGarbageCollectedMap(GCPredicate<K, V> predicate) {
        return this.createGarbageCollectedMap(predicate, m -> {});
    }

    public <K, V> Map<K, V> createGarbageCollectedMap(GCPredicate<K, V> predicate, Consumer<Map<K, V>> worldUnloadHook) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        this.maps.add(new GCEntry(map, predicate, worldUnloadHook));
        if (this.collector == null) {
            this.collector = new GarbageCollector<GCEntry>(this.maps, GCManager::processMap);
            this.collector.start();
        }
        return map;
    }

    private static <K, V> void processMap(GCEntry<K, V> entry) {
        Set<Object> toCollect = entry.map.entrySet().stream().filter(e -> entry.predicate.isGarbage(e.getKey(), e.getValue())).map(e -> e.getKey()).collect(Collectors.toSet());
        toCollect.forEach(k -> entry.map.remove(k));
    }

    public void unloadWorld() {
        for (GCEntry entry : this.maps) {
            entry.hook.accept(entry.map);
        }
    }

    private static class GCEntry<K, V> {
        Map<K, V> map;
        GCPredicate<K, V> predicate;
        Consumer<Map<K, V>> hook;

        public GCEntry(Map<K, V> map, GCPredicate<K, V> predicate, Consumer<Map<K, V>> hook) {
            this.map = map;
            this.predicate = predicate;
            this.hook = hook;
        }
    }
}

