/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.anvillib.garbagecollection;

import java.util.Set;
import java.util.function.Consumer;

public class GarbageCollector<T>
implements Runnable {
    private Set<T> targets;
    private Consumer<T> gcJob;
    private boolean isRunning = false;
    private Thread ownThread = null;

    public GarbageCollector(Set<T> targets, Consumer<T> gcJob) {
        this.targets = targets;
        this.gcJob = gcJob;
    }

    @Override
    public void run() {
        boolean isInThread;
        Thread current = Thread.currentThread();
        boolean bl = isInThread = current == this.ownThread;
        while (isInThread) {
            for (T target : this.targets) {
                this.gcJob.accept(target);
            }
            if (!isInThread) continue;
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public Thread asThread() {
        if (this.ownThread == null) {
            this.ownThread = new Thread((Runnable)this, "AnvilLib Garbage Collector");
        }
        return this.ownThread;
    }

    public void start() {
        if (!this.isRunning) {
            this.asThread().start();
            this.isRunning = true;
        }
    }
}

