/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.anvillib.network;

import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.anvilcraft.alec.jalec.AlecLogger;
import net.anvilcraft.anvillib.network.AnvilPacket;
import net.anvilcraft.anvillib.network.IAnvilPacket;
import net.anvilcraft.anvillib.usercache.UserCache;

@AnvilPacket(value=Side.CLIENT)
public class PacketUpdateUserCache
implements IAnvilPacket {
    public Map<UUID, String> entries;

    public PacketUpdateUserCache(Map<UUID, String> entries) {
        this.entries = entries;
    }

    public PacketUpdateUserCache() {
    }

    public void toBytes(ByteBuf buf) {
        for (Map.Entry<UUID, String> ent : this.entries.entrySet()) {
            buf.writeLong(ent.getKey().getMostSignificantBits());
            buf.writeLong(ent.getKey().getLeastSignificantBits());
            buf.writeInt(ent.getValue().length());
            buf.writeBytes(ent.getValue().getBytes());
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.entries = new HashMap<UUID, String>();
        while (buf.readableBytes() > 0) {
            UUID id = new UUID(buf.readLong(), buf.readLong());
            byte[] nameBytes = new byte[buf.readInt()];
            buf.readBytes(nameBytes);
            String name = new String(nameBytes);
            this.entries.put(id, name);
        }
    }

    @Override
    public void handle(MessageContext ctx) {
        UserCache.INSTANCE.users.putAll(this.entries);
        AlecLogger.PLAIN.alec("AAAAALEEEEEC");
    }
}

