/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.anvillib.usercache;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;
import net.anvilcraft.anvillib.AnvilLib;
import net.anvilcraft.anvillib.network.PacketUpdateUserCache;
import net.anvilcraft.anvillib.usercache.UserCache;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.SaveHandler;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;

public class UserCacheEventHandler {
    @SubscribeEvent
    public void onPlayerSave(PlayerEvent.SaveToFile ev) {
        ev.entityPlayer.getEntityData().func_74778_a("anvillib:name", ev.entityPlayer.func_70005_c_());
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load ev) {
        if (ev.world.field_73011_w.field_76574_g != 0 || !(ev.world.func_72860_G() instanceof SaveHandler)) {
            return;
        }
        int loaded = 0;
        SaveHandler sh = (SaveHandler)ev.world.func_72860_G();
        for (String playerdat : sh.func_75754_f()) {
            try {
                File f = new File(sh.field_75771_c, playerdat + ".dat");
                UUID id = UUID.fromString(playerdat);
                NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(f));
                String name = tag.func_74775_l("ForgeData").func_74779_i("anvillib:name");
                if (name.isEmpty()) continue;
                UserCache.INSTANCE.addEntry(id, name);
                ++loaded;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        AnvilLib.LOGGER.info("Loaded {} usercache entries from player dat", new Object[]{loaded});
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent ev) {
        UserCache.INSTANCE.addEntry(ev.player);
        if (!(ev.player instanceof EntityPlayerMP) || ((EntityPlayerMP)ev.player).func_71114_r().equals("local")) {
            return;
        }
        AnvilLib.channel.sendTo(new PacketUpdateUserCache(UserCache.INSTANCE.users), (EntityPlayerMP)ev.player);
        PacketUpdateUserCache updatePkt = new PacketUpdateUserCache((Map<UUID, String>)ImmutableMap.of((Object)ev.player.func_110124_au(), (Object)ev.player.func_70005_c_()));
        for (EntityPlayerMP pl : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            if (pl == ev.player) continue;
            AnvilLib.channel.sendTo(updatePkt, pl);
        }
    }
}

