/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.anvillib.util;

import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import java.util.Random;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class AnvilUtil {
    public static final Random rand = new Random();

    public static <T extends Enum<T>> T enumFromInt(Class<T> clazz, int n) {
        Enum[] values = (Enum[])clazz.getEnumConstants();
        if (n < 0 || n >= values.length) {
            return null;
        }
        return (T)values[n];
    }

    public static NBTTagList uuidToNBT(UUID uuid) {
        NBTTagList nbt = new NBTTagList();
        nbt.func_74742_a((NBTBase)new NBTTagLong(uuid.getMostSignificantBits()));
        nbt.func_74742_a((NBTBase)new NBTTagLong(uuid.getLeastSignificantBits()));
        return nbt;
    }

    public static UUID uuidFromNBT(NBTTagList nbt) {
        if (nbt.func_74745_c() != 2 || !(nbt.field_74747_a.get(0) instanceof NBTTagLong) || !(nbt.field_74747_a.get(1) instanceof NBTTagLong)) {
            return null;
        }
        return new UUID(((NBTTagLong)nbt.field_74747_a.get(0)).func_150291_c(), ((NBTTagLong)nbt.field_74747_a.get(1)).func_150291_c());
    }

    public static void writeStringToPacket(String s, ByteBuf buf) {
        try {
            byte[] bytes = s.getBytes("ISO-8859-1");
            int length = bytes.length;
            buf.writeInt(length);
            buf.writeBytes(bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readStringFromPacket(ByteBuf buf) {
        int length = buf.readInt();
        byte[] bytes = new byte[length];
        buf.readBytes(bytes);
        try {
            return new String(bytes, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void dropInventoryContents(IInventory inv) {
        TileEntity te = (TileEntity)inv;
        IntStream.range(0, inv.func_70302_i_()).mapToObj(arg_0 -> ((IInventory)inv).func_70301_a(arg_0)).filter(stack -> stack != null && stack.field_77994_a > 0).map(stack -> {
            EntityItem ent = new EntityItem(te.func_145831_w(), (double)((float)te.field_145851_c + rand.nextFloat() * 0.8f + 0.1f), (double)((float)te.field_145848_d + rand.nextFloat() * 0.8f + 0.1f), (double)((float)te.field_145849_e + rand.nextFloat() * 0.8f + 0.1f), stack.func_77946_l());
            ent.field_70159_w = rand.nextGaussian() * (double)0.05f;
            ent.field_70181_x = rand.nextGaussian() * (double)0.05f + (double)0.2f;
            ent.field_70179_y = rand.nextGaussian() * (double)0.05f;
            return ent;
        }).forEach(arg_0 -> ((World)te.func_145831_w()).func_72838_d(arg_0));
    }
}

