/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.anvillib.vector;

import io.netty.buffer.ByteBuf;
import net.anvilcraft.anvillib.vector.WorldVec;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Vec3 {
    public double x;
    public double y;
    public double z;

    public Vec3(Vec3 vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    public Vec3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3(Entity ent) {
        this(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
    }

    public Vec3(TileEntity te) {
        this(te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public Vec3(MovingObjectPosition mop) {
        this(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
    }

    public static Vec3 readFromByteBuf(ByteBuf buf) {
        return new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public int intX() {
        return (int)Math.floor(this.x);
    }

    public int intY() {
        return (int)Math.floor(this.y);
    }

    public int intZ() {
        return (int)Math.floor(this.z);
    }

    public WorldVec withWorld(World world) {
        return new WorldVec(world, this.x, this.y, this.z);
    }

    public void writeToByteBuf(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
    }

    public Vec3 offset(ForgeDirection dir, double amt) {
        this.x += (double)dir.offsetX * amt;
        this.y += (double)dir.offsetY * amt;
        this.z += (double)dir.offsetZ * amt;
        return this;
    }

    public Vec3 offset(ForgeDirection dir) {
        return this.offset(dir, 1.0);
    }

    public Vec3 offset(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vec3 offset(Vec3 other) {
        return this.offset(other.x, other.y, other.z);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vec3 other = (Vec3)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
    }

    public String toString() {
        return "Vec (" + this.x + " " + this.y + " " + this.z + ")";
    }
}

