/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vsplit.platform;

import com.github.litermc.vsplit.config.ConfigFile;
import com.github.litermc.vsplit.network.MessageType;
import com.github.litermc.vsplit.network.NetworkMessage;
import com.github.litermc.vsplit.network.client.ClientNetworkContext;
import com.github.litermc.vsplit.network.container.ContainerData;
import com.github.litermc.vsplit.platform.FabricConfigFile;
import com.github.litermc.vsplit.platform.FabricMessageType;
import com.github.litermc.vsplit.platform.FakePlayer;
import com.github.litermc.vsplit.platform.PlatformHelper;
import com.github.litermc.vsplit.platform.RegistrationHelper;
import com.github.litermc.vsplit.platform.RegistryEntry;
import com.github.litermc.vsplit.platform.RegistryWrappers;
import com.google.auto.service.AutoService;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1270;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

@AutoService(value={PlatformHelper.class})
public final class PlatformHelperImpl
implements PlatformHelper {
    public static volatile MinecraftServer minecraftServer = null;

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public ConfigFile.Builder createConfigBuilder() {
        return new FabricConfigFile.Builder();
    }

    @Override
    public MinecraftServer getCurrentServer() {
        return minecraftServer;
    }

    @Override
    public boolean isModLoaded(String modid) {
        return FabricLoader.getInstance().isModLoaded(modid);
    }

    private static <T> class_2378<T> getRegistry(class_5321<class_2378<T>> id) {
        class_2378 registry = (class_2378)class_7923.field_41167.method_10223(id.method_29177());
        if (registry == null) {
            throw new IllegalArgumentException("Unknown registry " + id);
        }
        return registry;
    }

    @Override
    public <T> class_2960 getRegistryKey(class_5321<class_2378<T>> registry, T object) {
        class_2960 key = PlatformHelperImpl.getRegistry(registry).method_10221(object);
        if (key == null) {
            throw new IllegalArgumentException(object + " was not registered in " + registry);
        }
        return key;
    }

    @Override
    public <T> T getRegistryObject(class_5321<class_2378<T>> registry, class_2960 id) {
        Object value = PlatformHelperImpl.getRegistry(registry).method_10223(id);
        if (value == null) {
            throw new IllegalArgumentException(id + " was not registered in " + registry);
        }
        return (T)value;
    }

    @Override
    public <T> RegistryWrappers.RegistryWrapper<T> wrap(class_5321<class_2378<T>> registry) {
        return new RegistryWrapperImpl<T>(registry.method_29177(), PlatformHelperImpl.getRegistry(registry));
    }

    @Override
    public <T> RegistrationHelper<T> createRegistrationHelper(class_5321<class_2378<T>> registry) {
        return new RegistrationHelperImpl<T>(PlatformHelperImpl.getRegistry(registry));
    }

    @Override
    @Nullable
    public <T> T tryGetRegistryObject(class_5321<class_2378<T>> registry, class_2960 id) {
        return (T)PlatformHelperImpl.getRegistry(registry).method_10223(id);
    }

    @Override
    public <T extends class_2586> class_2591<T> createBlockEntityType(BiFunction<class_2338, class_2680, T> factory, class_2248 block) {
        return FabricBlockEntityTypeBuilder.create(factory::apply, (class_2248[])new class_2248[0]).addBlock(block).build();
    }

    @Override
    public <C extends class_1703, T extends ContainerData> class_3917<C> createMenuType(Function<class_2540, T> reader, ContainerData.Factory<C, T> factory) {
        return new ExtendedScreenHandlerType((id, player, data) -> factory.create(id, player, (ContainerData)reader.apply(data)));
    }

    @Override
    public void openMenu(class_1657 player, class_2561 title, class_1270 menu, ContainerData data) {
        player.method_17355((class_3908)new WrappedMenuProvider(title, menu, data));
    }

    @Override
    public <T extends NetworkMessage<?>> MessageType<T> createMessageType(int id, class_2960 channel, Class<T> klass, class_2540.class_7461<T> reader) {
        return new FabricMessageType(channel, reader);
    }

    @Override
    public class_2596<class_2602> createPacket(NetworkMessage<ClientNetworkContext> message) {
        class_2540 buf = PacketByteBufs.create();
        message.write(buf);
        return ServerPlayNetworking.createS2CPacket((class_2960)FabricMessageType.toFabricType(message.type()).getId(), (class_2540)buf);
    }

    @Override
    public class_1761.class_7913 newCreativeModeTab() {
        return FabricItemGroup.builder();
    }

    @Override
    public class_3222 createFakePlayer(class_3218 world, GameProfile name) {
        return FakePlayer.create(world, name);
    }

    private record RegistryWrapperImpl<T>(class_2960 name, class_2378<T> registry) implements RegistryWrappers.RegistryWrapper<T>
    {
        public int method_10206(T object) {
            return this.registry.method_10206(object);
        }

        @Override
        public class_2960 getKey(T object) {
            class_2960 key = this.registry.method_10221(object);
            if (key == null) {
                throw new IllegalArgumentException(object + " was not registered in " + this.name);
            }
            return key;
        }

        @Override
        public T get(class_2960 location) {
            Object object = this.registry.method_10223(location);
            if (object == null) {
                throw new IllegalArgumentException(location + " was not registered in " + this.name);
            }
            return (T)object;
        }

        @Override
        @Nullable
        public T tryGet(class_2960 location) {
            return (T)this.registry.method_10223(location);
        }

        @Nullable
        public T method_10200(int id) {
            return (T)this.registry.method_10200(id);
        }

        public int method_10204() {
            return this.registry.method_10204();
        }

        public Iterator<T> iterator() {
            return this.registry.iterator();
        }
    }

    private static final class RegistrationHelperImpl<T>
    implements RegistrationHelper<T> {
        private final class_2378<T> registry;
        private final List<RegistryEntryImpl<? extends T>> entries = new ArrayList<RegistryEntryImpl<? extends T>>();

        private RegistrationHelperImpl(class_2378<T> registry) {
            this.registry = registry;
        }

        @Override
        public <U extends T> RegistryEntry<U> register(String name, Supplier<U> create) {
            RegistryEntryImpl<U> entry = new RegistryEntryImpl<U>(new class_2960("vsplit", name), create);
            this.entries.add(entry);
            return entry;
        }

        @Override
        public void register() {
            for (RegistryEntryImpl<T> entry : this.entries) {
                entry.register(this.registry);
            }
        }
    }

    private record WrappedMenuProvider(class_2561 title, class_1270 menu, ContainerData data) implements ExtendedScreenHandlerFactory
    {
        @Nullable
        public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
            return this.menu.createMenu(id, inventory, player);
        }

        public class_2561 method_5476() {
            return this.title;
        }

        public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
            this.data.toBytes(buf);
        }
    }

    private static final class RegistryEntryImpl<T>
    implements RegistryEntry<T> {
        private final class_2960 id;
        private final Supplier<T> supplier;
        @Nullable
        private T instance;

        RegistryEntryImpl(class_2960 id, Supplier<T> supplier) {
            this.id = id;
            this.supplier = supplier;
        }

        void register(class_2378<? super T> registry) {
            this.instance = this.supplier.get();
            class_2378.method_10230(registry, (class_2960)this.id, this.instance);
        }

        @Override
        public class_2960 id() {
            return this.id;
        }

        @Override
        public T get() {
            if (this.instance == null) {
                throw new IllegalStateException(this.id + " has not been constructed yet");
            }
            return this.instance;
        }
    }
}

