/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vsplit;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.github.litermc.vsplit.VSplitListeners;
import com.github.litermc.vsplit.block.BlockCapabilityProviders;
import com.github.litermc.vsplit.command.VSplitCommands;
import com.github.litermc.vsplit.config.ConfigSpec;
import com.github.litermc.vsplit.platform.ForgeConfigFile;
import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Path;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="vsplit")
@Mod.EventBusSubscriber
public class ModEntry {
    public ModEntry() {
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        IEventBus modBus = context.getModEventBus();
        VSplitListeners.onModInit();
        BlockCapabilityProviders.register();
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)((ForgeConfigFile)ConfigSpec.serverSpec).spec());
        modBus.addListener(this::onConfigLoad);
        modBus.addListener(this::onConfigReload);
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            VSplitListeners.onServerLevelLoad(level);
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            VSplitListeners.onServerLevelUnload(level);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        switch (event.phase) {
            case START: {
                VSplitListeners.preServerTick(event.getServer());
                break;
            }
            case END: {
                VSplitListeners.postServerTick(event.getServer());
            }
        }
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        VSplitCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void onConfigLoad(ModConfigEvent.Loading event) {
        this.syncConfig(event.getConfig());
    }

    private void onConfigReload(ModConfigEvent.Reloading event) {
        this.syncConfig(event.getConfig());
    }

    private void syncConfig(ModConfig config) {
        Path path;
        if (!config.getModId().equals("vsplit")) {
            return;
        }
        CommentedConfig commentedConfig = config.getConfigData();
        if (commentedConfig instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)commentedConfig;
            v0 = fileConfig.getNioPath();
        } else {
            v0 = path = null;
        }
        if (config.getType() == ModConfig.Type.SERVER && ((ForgeConfigFile)ConfigSpec.serverSpec).spec().isLoaded()) {
            ConfigSpec.syncServer(path);
        } else if (config.getType() == ModConfig.Type.CLIENT) {
            ConfigSpec.syncClient(path);
        }
    }
}

