/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vsplit.network;

import com.github.litermc.vsplit.network.MessageType;
import com.github.litermc.vsplit.network.NetworkMessage;
import com.github.litermc.vsplit.network.client.ClientNetworkContext;
import com.github.litermc.vsplit.network.server.ServerNetworkContext;
import com.github.litermc.vsplit.platform.PlatformHelper;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public final class NetworkMessages {
    private static final IntSet seenIds = new IntOpenHashSet();
    private static final Set<String> seenChannel = new HashSet<String>();
    private static final List<MessageType<? extends NetworkMessage<ServerNetworkContext>>> serverMessages = new ArrayList<MessageType<? extends NetworkMessage<ServerNetworkContext>>>();
    private static final List<MessageType<? extends NetworkMessage<ClientNetworkContext>>> clientMessages = new ArrayList<MessageType<? extends NetworkMessage<ClientNetworkContext>>>();

    private NetworkMessages() {
    }

    private static <C, T extends NetworkMessage<C>> MessageType<T> register(List<MessageType<? extends NetworkMessage<C>>> messages, int id, String channel, Class<T> klass, FriendlyByteBuf.Reader<T> reader) {
        if (!seenIds.add(id)) {
            throw new IllegalArgumentException("Duplicate id " + id);
        }
        if (!seenChannel.add(channel)) {
            throw new IllegalArgumentException("Duplicate channel " + channel);
        }
        MessageType<T> type = PlatformHelper.get().createMessageType(id, new ResourceLocation("vsplit", channel), klass, reader);
        messages.add(type);
        return type;
    }

    private static <T extends NetworkMessage<ServerNetworkContext>> MessageType<T> registerServerbound(int id, String channel, Class<T> klass, FriendlyByteBuf.Reader<T> reader) {
        return NetworkMessages.register(serverMessages, id, channel, klass, reader);
    }

    private static <T extends NetworkMessage<ClientNetworkContext>> MessageType<T> registerClientbound(int id, String channel, Class<T> klass, FriendlyByteBuf.Reader<T> reader) {
        return NetworkMessages.register(clientMessages, id, channel, klass, reader);
    }

    public static Collection<MessageType<? extends NetworkMessage<ServerNetworkContext>>> getServerbound() {
        return Collections.unmodifiableCollection(serverMessages);
    }

    public static Collection<MessageType<? extends NetworkMessage<ClientNetworkContext>>> getClientbound() {
        return Collections.unmodifiableCollection(clientMessages);
    }
}

