/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vsplit.platform;

import com.github.litermc.vsplit.config.ConfigFile;
import com.github.litermc.vsplit.network.MessageType;
import com.github.litermc.vsplit.network.NetworkMessage;
import com.github.litermc.vsplit.network.client.ClientNetworkContext;
import com.github.litermc.vsplit.network.container.ContainerData;
import com.github.litermc.vsplit.platform.RegistrationHelper;
import com.github.litermc.vsplit.platform.RegistryWrappers;
import com.github.litermc.vsplit.platform.Services;
import com.mojang.authlib.GameProfile;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public interface PlatformHelper {
    public static PlatformHelper get() {
        PlatformHelper instance = Instance.INSTANCE;
        return instance == null ? Services.raise(PlatformHelper.class, Instance.ERROR) : instance;
    }

    public boolean isDevelopmentEnvironment();

    public ConfigFile.Builder createConfigBuilder();

    public MinecraftServer getCurrentServer();

    public boolean isModLoaded(String var1);

    public <T> RegistryWrappers.RegistryWrapper<T> wrap(ResourceKey<Registry<T>> var1);

    public <T> RegistrationHelper<T> createRegistrationHelper(ResourceKey<Registry<T>> var1);

    @Nullable
    public <T> T tryGetRegistryObject(ResourceKey<Registry<T>> var1, ResourceLocation var2);

    public <T> ResourceLocation getRegistryKey(ResourceKey<Registry<T>> var1, T var2);

    public <T> T getRegistryObject(ResourceKey<Registry<T>> var1, ResourceLocation var2);

    public <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(BiFunction<BlockPos, BlockState, T> var1, Block var2);

    public <C extends AbstractContainerMenu, T extends ContainerData> MenuType<C> createMenuType(Function<FriendlyByteBuf, T> var1, ContainerData.Factory<C, T> var2);

    public void openMenu(Player var1, Component var2, MenuConstructor var3, ContainerData var4);

    public <T extends NetworkMessage<?>> MessageType<T> createMessageType(int var1, ResourceLocation var2, Class<T> var3, FriendlyByteBuf.Reader<T> var4);

    public Packet<ClientGamePacketListener> createPacket(NetworkMessage<ClientNetworkContext> var1);

    public CreativeModeTab.Builder newCreativeModeTab();

    public ServerPlayer createFakePlayer(ServerLevel var1, GameProfile var2);

    default public boolean isFakePlayer(ServerPlayer player) {
        return player.f_8906_ == null || player.getClass() != ServerPlayer.class;
    }

    public static final class Instance {
        @Nullable
        static final PlatformHelper INSTANCE;
        @Nullable
        static final Throwable ERROR;

        private Instance() {
        }

        static {
            Services.LoadedService<PlatformHelper> helper = Services.tryLoad(PlatformHelper.class);
            INSTANCE = helper.instance();
            ERROR = helper.error();
        }
    }
}

