/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vsplit.util;

import com.github.litermc.vsplit.accessor.ShipObjectServerAccessor;
import com.github.litermc.vsplit.api.attachment.ISplitListener;
import com.github.litermc.vsplit.config.Config;
import com.github.litermc.vtil.api.assemble.AssembleApi;
import com.github.litermc.vtil.api.connectivity.BlockConnectivityApi;
import com.github.litermc.vtil.util.LevelUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public final class SplitUtil {
    private static final Map<LoadedServerShip, Map<BlockPos, OldStateHolder>> UPDATING_SHIP = new HashMap<LoadedServerShip, Map<BlockPos, OldStateHolder>>();
    private static int PART_COUNTER = 0;

    private SplitUtil() {
    }

    public static void onBlockUpdated(ServerLevel level, BlockPos pos, BlockState oldState, BlockState newState) {
        if (!Config.enableShipSplit) {
            return;
        }
        LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)level, (Vec3i)pos);
        if (ship == null) {
            return;
        }
        Map updates = UPDATING_SHIP.computeIfAbsent(ship, s -> new HashMap());
        if (updates.containsKey(pos)) {
            return;
        }
        if (BlockConnectivityApi.isAir((BlockState)oldState)) {
            updates.put(pos, new OldStateHolder(oldState, List.of()));
        } else {
            ArrayList<BlockPos> prevConns = new ArrayList<BlockPos>(6);
            BlockConnectivityApi.getPossibleConnectableBlocks((LevelAccessor)level, (BlockPos)pos, (BlockState)oldState, prevConns);
            updates.put(pos, new OldStateHolder(oldState, prevConns));
        }
    }

    public static void postServerTick() {
        if (UPDATING_SHIP.isEmpty()) {
            return;
        }
        Map<LoadedServerShip, Map<BlockPos, OldStateHolder>> updating = Map.copyOf(UPDATING_SHIP);
        UPDATING_SHIP.clear();
        ArrayList<ISplitListener> listeners = new ArrayList<ISplitListener>(0);
        ArrayList<Consumer<ServerShip>> callbacks = new ArrayList<Consumer<ServerShip>>(0);
        for (Map.Entry<LoadedServerShip, Map<BlockPos, OldStateHolder>> entry : updating.entrySet()) {
            ShipObjectServerAccessor slGetter0;
            LoadedServerShip ship = entry.getKey();
            ShipObjectServerAccessor slGetter = ship instanceof ShipObjectServerAccessor ? (slGetter0 = (ShipObjectServerAccessor)ship) : null;
            Map<BlockPos, OldStateHolder> updates = entry.getValue();
            ServerLevel level = LevelUtil.getLevel((String)ship.getChunkClaimDimension());
            List<Set<BlockPos>> parts = SplitUtil.getSeparatedParts((Level)level, (Ship)ship, updates);
            if (parts == null) continue;
            String slug = SplitUtil.extractBaseSlug(ship.getSlug());
            for (Set<BlockPos> part : parts) {
                ServerShip splittedShip;
                if (slGetter != null) {
                    SplitContext context = new SplitContext((ServerShip)ship, Collections.unmodifiableSet(part), callbacks);
                    listeners.addAll(slGetter.vsplit$getSplitListeners());
                    for (ISplitListener iSplitListener : listeners) {
                        iSplitListener.onShipSplit(context);
                    }
                    listeners.clear();
                }
                if ((splittedShip = AssembleApi.createShip((ServerLevel)level, part, (ServerShip)ship)) == null) continue;
                splittedShip.setSlug(SplitUtil.addPartSlug(slug));
                if (slGetter == null) continue;
                for (Consumer consumer : callbacks) {
                    consumer.accept(splittedShip);
                }
                callbacks.clear();
            }
        }
    }

    private static String extractBaseSlug(String slug) {
        if (slug == null) {
            return null;
        }
        int partIndex = slug.lastIndexOf("+part-");
        if (partIndex == -1) {
            return slug;
        }
        return slug.substring(0, partIndex);
    }

    private static String addPartSlug(String slug) {
        if (slug == null) {
            return null;
        }
        if (++PART_COUNTER >= 10000) {
            PART_COUNTER = 1;
        }
        return String.format("%s+part-%04d", slug, PART_COUNTER);
    }

    public static List<Set<BlockPos>> getSeparatedParts(Level level, Ship ship, Map<BlockPos, OldStateHolder> updates) {
        int polled;
        HashMap<BlockPos, PartHolder> visited = new HashMap<BlockPos, PartHolder>(32);
        HashSet<PartHolder> parts = new HashSet<PartHolder>(updates.size() * 2);
        HashSet nextPosSet = new HashSet(6);
        for (Map.Entry<BlockPos, OldStateHolder> update : updates.entrySet()) {
            BlockPos startBlock = update.getKey();
            OldStateHolder prevState = update.getValue();
            BlockState newState = level.m_8055_(startBlock);
            if (!BlockConnectivityApi.willConnectivityChange((LevelAccessor)level, (BlockPos)startBlock, (BlockState)prevState.state(), (BlockState)newState)) continue;
            if (!BlockConnectivityApi.isAir((BlockState)newState)) {
                if (!visited.containsKey(startBlock)) {
                    PartHolder partHolder = new PartHolder(new Part(startBlock));
                    parts.add(partHolder);
                    visited.put(startBlock, partHolder);
                }
                BlockConnectivityApi.getPossibleConnectableBlocks((LevelAccessor)level, (BlockPos)startBlock, (BlockState)newState, nextPosSet);
            }
            if (prevState.connections().isEmpty()) {
                for (BlockPos conn : nextPosSet) {
                    if (visited.containsKey(conn) || BlockConnectivityApi.isAir((BlockState)level.m_8055_(conn))) continue;
                    p = new PartHolder(new Part(conn));
                    parts.add(p);
                    visited.put(conn, p);
                }
            } else {
                for (BlockPos conn : prevState.connections()) {
                    if (nextPosSet.contains(conn) || visited.containsKey(conn) || BlockConnectivityApi.isAir((BlockState)level.m_8055_(conn))) continue;
                    p = new PartHolder(new Part(conn));
                    parts.add(p);
                    visited.put(conn, p);
                }
            }
            nextPosSet.clear();
        }
        if (parts.size() <= 1) {
            return null;
        }
        ArrayList nextPoses = new ArrayList(6);
        ArrayList<Set<BlockPos>> scannedParts = new ArrayList<Set<BlockPos>>();
        HashSet<PartHolder> partsCopy = new HashSet<PartHolder>(parts.size());
        do {
            polled = 0;
            partsCopy.clear();
            partsCopy.addAll(parts);
            for (PartHolder partHolder : partsCopy) {
                if (!parts.contains(partHolder)) continue;
                Part part = partHolder.getForward().part;
                if (part.complete) {
                    parts.remove(partHolder);
                    continue;
                }
                BlockPos pos = part.poll();
                if (pos == null) {
                    part.complete = true;
                    scannedParts.add(part.blocks);
                    parts.remove(part);
                    continue;
                }
                ++polled;
                BlockState state = level.m_8055_(pos);
                nextPoses.clear();
                BlockConnectivityApi.getPossibleConnectableBlocks((LevelAccessor)level, (BlockPos)pos, (BlockState)state, nextPoses);
                for (BlockPos p : nextPoses) {
                    BlockState s;
                    if (part.blocks.contains(p) || BlockConnectivityApi.isAir((BlockState)(s = level.m_8055_(p))) || !BlockConnectivityApi.isBlockConnectable((LevelAccessor)level, (BlockPos)p, (BlockState)s, (BlockPos)pos, (BlockState)state)) continue;
                    PartHolder otherHolder = (PartHolder)visited.get(p);
                    if (otherHolder != null) {
                        otherHolder = otherHolder.getForward();
                        Part otherPart = otherHolder.part;
                        if (otherPart == part) continue;
                        part.merge(otherPart);
                        otherPart.complete = true;
                        otherHolder.forward = partHolder;
                        parts.remove(otherHolder);
                        if (!scannedParts.isEmpty() || parts.size() > 1) continue;
                        return null;
                    }
                    part.add(p);
                    visited.put(p, partHolder);
                }
            }
        } while (polled > true);
        if (parts.isEmpty()) {
            scannedParts.remove(scannedParts.size() - 1);
        }
        return scannedParts;
    }

    public record OldStateHolder(BlockState state, Collection<BlockPos> connections) {
    }

    private static final class SplitContext
    implements ISplitListener.Context {
        private final ServerShip ship;
        private final Set<BlockPos> blocks;
        private final List<Consumer<ServerShip>> callbacks;

        private SplitContext(ServerShip ship, Set<BlockPos> blocks, List<Consumer<ServerShip>> callbacks) {
            this.ship = ship;
            this.blocks = blocks;
            this.callbacks = callbacks;
        }

        @Override
        public ServerShip getShip() {
            return this.ship;
        }

        @Override
        public Set<BlockPos> getBlocks() {
            return this.blocks;
        }

        @Override
        public void addAfterSplit(Consumer<ServerShip> callback) {
            if (callback == null) {
                throw new IllegalArgumentException("callback cannot be null");
            }
            this.callbacks.add(callback);
        }
    }

    private static final class PartHolder {
        final Part part;
        PartHolder forward = null;

        PartHolder(Part part) {
            this.part = part;
        }

        PartHolder getForward() {
            if (this.forward != null) {
                return this.forward.getForward();
            }
            return this;
        }
    }

    private static final class Part {
        final Set<BlockPos> blocks = new HashSet<BlockPos>();
        final Queue<BlockPos> pending = new ArrayDeque<BlockPos>();
        boolean complete = false;

        Part(BlockPos startBlock) {
            this.add(startBlock);
        }

        void merge(Part other) {
            BlockPos pos;
            if (other.complete) {
                throw new RuntimeException("Unexpected early stopped scan. Connectivity inconsistent?");
            }
            this.blocks.addAll(other.blocks);
            while ((pos = other.poll()) != null) {
                this.pending.add(pos);
            }
        }

        BlockPos poll() {
            return this.pending.poll();
        }

        void add(BlockPos pos) {
            if (this.blocks.add(pos)) {
                this.pending.add(pos);
            }
        }
    }
}

