/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vsplit.api.clean;

import com.github.litermc.vsplit.Constants;
import com.github.litermc.vsplit.accessor.ShipObjectServerAccessor;
import com.github.litermc.vsplit.api.clean.ICleanListener;
import com.github.litermc.vsplit.attachment.ShipCleanAttachment;
import com.github.litermc.vsplit.impl.clean.ShipBlockCountCleaner;
import com.github.litermc.vsplit.impl.clean.ShipPlayerProtectionCleaner;
import com.github.litermc.vtil.api.assemble.ShipAllocator;
import com.github.litermc.vtil.util.LevelUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public final class ShipCleaner {
    private static LinkedHashSet<ICleanListener> REGISTERING_LISTENERS = new LinkedHashSet();
    private static List<ICleanListener> LISTENERS = null;

    private ShipCleaner() {
    }

    public static void registerListener(ICleanListener listener) {
        if (REGISTERING_LISTENERS == null) {
            throw new IllegalStateException("registerListener should only be invoked while mod initializing");
        }
        if (!REGISTERING_LISTENERS.contains(listener)) {
            REGISTERING_LISTENERS.add(listener);
        }
    }

    private static List<ICleanListener> getListeners() {
        if (LISTENERS == null) {
            ArrayList<ICleanListener> listeners = new ArrayList<ICleanListener>(REGISTERING_LISTENERS);
            REGISTERING_LISTENERS = null;
            listeners.sort((a, b) -> Integer.compare(a.getShipCleanPriority(), b.getShipCleanPriority()));
            LISTENERS = List.copyOf(listeners);
        }
        return LISTENERS;
    }

    public static void setShipProtected(LoadedServerShip ship, boolean protect) {
        ShipCleanAttachment attachment = ShipCleanAttachment.get(ship);
        attachment.setProtected(protect);
        if (protect) {
            attachment.setMarked(false);
        }
    }

    public static int clean(MinecraftServer server, boolean forceRemove) {
        Constants.LOG.info("[vsplit]: Cleaning ships. forceRemove = {}", (Object)forceRemove);
        server.method_3760().method_43514((class_2561)Constants.MESSAGE_PREFIX.method_27661().method_10852((class_2561)class_2561.method_43471((String)"vsplit.message.clean.start")), false);
        int count = 0;
        ShipAllocator allocator = ShipAllocator.get((MinecraftServer)server);
        ServerShipWorldCore world = VSGameUtilsKt.getShipObjectWorld((MinecraftServer)server);
        List<ICleanListener> generalListeners = ShipCleaner.getListeners();
        for (LoadedServerShip ship : new ShipAllocator.SafeShipIterable((Iterable)world.getLoadedShips())) {
            List<ICleanListener> listeners;
            List shipListeners;
            class_3218 level = LevelUtil.getLevel((String)ship.getChunkClaimDimension());
            ShipCleanAttachment cleanAttachment = ShipCleanAttachment.get(ship);
            if (cleanAttachment.isProtected()) continue;
            if (ship instanceof ShipObjectServerAccessor) {
                ShipObjectServerAccessor shipObject = (ShipObjectServerAccessor)ship;
                v0 = shipObject.vsplit$getCleanListeners();
            } else {
                v0 = shipListeners = Collections.emptyList();
            }
            if (shipListeners.isEmpty()) {
                listeners = generalListeners;
            } else {
                listeners = new ArrayList<ICleanListener>(generalListeners.size() + shipListeners.size());
                Iterator<ICleanListener> gIter = generalListeners.iterator();
                Iterator<ICleanListener> sIter = shipListeners.iterator();
                Object gCurrent = gIter.next();
                ICleanListener sCurrent = (ICleanListener)sIter.next();
                while (true) {
                    if (gCurrent.getShipCleanPriority() <= sCurrent.getShipCleanPriority()) {
                        listeners.add((ICleanListener)gCurrent);
                        if (!gIter.hasNext()) {
                            listeners.add(sCurrent);
                            sIter.forEachRemaining(listeners::add);
                            break;
                        }
                        gCurrent = gIter.next();
                        continue;
                    }
                    listeners.add(sCurrent);
                    if (!sIter.hasNext()) {
                        listeners.add((ICleanListener)gCurrent);
                        gIter.forEachRemaining(listeners::add);
                        break;
                    }
                    sCurrent = (ICleanListener)sIter.next();
                }
            }
            boolean marked = cleanAttachment.isMarked();
            CleanContext context = new CleanContext(level, (ServerShip)ship, marked);
            for (ICleanListener listener : listeners) {
                listener.onShipClean(context);
            }
            boolean shouldClean = context.getCleanSuggestion();
            if (!forceRemove && shouldClean != marked) {
                Constants.LOG.debug("[vsplit]: Ship {} marked = {}", (Object)ship.getId(), (Object)shouldClean);
                cleanAttachment.setMarked(shouldClean);
                continue;
            }
            if (!shouldClean) continue;
            Constants.LOG.info("[vsplit]: Cleaning ship {} ({})", (Object)ship.getId(), (Object)ship.getSlug());
            allocator.putShip((ServerShip)ship);
            ++count;
        }
        if (count == 0) {
            server.method_3760().method_43514((class_2561)Constants.MESSAGE_PREFIX.method_27661().method_10852((class_2561)class_2561.method_43471((String)"vsplit.message.clean.success.none")), false);
        } else {
            server.method_3760().method_43514((class_2561)Constants.MESSAGE_PREFIX.method_27661().method_10852((class_2561)class_2561.method_43469((String)"vsplit.message.clean.success", (Object[])new Object[]{count})), false);
        }
        return count;
    }

    static {
        ShipCleaner.registerListener(ShipBlockCountCleaner.INSTANCE);
        ShipCleaner.registerListener(ShipPlayerProtectionCleaner.INSTANCE);
    }

    private static final class CleanContext
    implements ICleanListener.Context {
        private final class_3218 level;
        private final ServerShip ship;
        private final boolean marked;
        private boolean cleanSuggestion = false;
        private boolean skipFlag = false;

        private CleanContext(class_3218 level, ServerShip ship, boolean marked) {
            this.level = level;
            this.ship = ship;
            this.marked = marked;
        }

        @Override
        public class_3218 getLevel() {
            return this.level;
        }

        @Override
        public ServerShip getShip() {
            return this.ship;
        }

        @Override
        public boolean wasMarked() {
            return this.marked;
        }

        @Override
        public boolean getCleanSuggestion() {
            return this.cleanSuggestion;
        }

        @Override
        public void setCleanSuggestion(boolean suggestion) {
            this.cleanSuggestion = suggestion;
        }

        @Override
        public void skipCheck() {
            this.skipFlag = true;
        }
    }
}

