/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vsplit.command;

import com.github.litermc.vsplit.api.clean.ShipCleaner;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Set;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.command.ShipArgument;

public final class VSplitCommands {
    public static final String ROOT_LITERAL = "vsplit";

    private VSplitCommands() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)ROOT_LITERAL).requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clean").then(class_2170.method_9244((String)"forceRemoval", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> VSplitCommands.clean((CommandContext<class_2168>)ctx, BoolArgumentType.getBool((CommandContext)ctx, (String)"forceRemoval"))))).executes(ctx -> VSplitCommands.clean((CommandContext<class_2168>)ctx, false)))).then(class_2170.method_9247((String)"protect").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"ships", (ArgumentType)ShipArgument.Companion.ships()).then(class_2170.method_9244((String)"shouldProtect", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> VSplitCommands.protect((CommandContext<class_2168>)ctx, BoolArgumentType.getBool((CommandContext)ctx, (String)"shouldProtect"))))).executes(ctx -> VSplitCommands.protect((CommandContext<class_2168>)ctx, true)))));
    }

    private static int clean(CommandContext<class_2168> context, boolean forceRemoval) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        ShipCleaner.clean(server, forceRemoval);
        return 1;
    }

    private static int protect(CommandContext<class_2168> context, boolean shouldProtect) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        ServerShipWorldCore world = VSGameUtilsKt.getShipObjectWorld((MinecraftServer)server);
        Set ships = ShipArgument.Companion.getShips(context, "ships");
        int count = 0;
        for (Ship ship : ships) {
            if (!(ship instanceof ServerShip)) continue;
            ServerShip serverShip = (ServerShip)ship;
            LoadedServerShip loadedShip = (LoadedServerShip)world.getLoadedShips().getById(ship.getId());
            if (loadedShip == null) continue;
            ShipCleaner.setShipProtected(loadedShip, shouldProtect);
            ++count;
        }
        int finalCount = count;
        source.method_9226(() -> class_2561.method_43469((String)"vsplit.command.protect.success", (Object[])new Object[]{finalCount}), false);
        return count;
    }
}

