/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vsplit.impl.clean;

import com.github.litermc.vsplit.Constants;
import com.github.litermc.vsplit.api.clean.ShipCleaner;
import com.github.litermc.vsplit.config.Config;
import java.time.Duration;
import java.time.Instant;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;

public final class CleanScheduler {
    private static Instant nextCleanup;
    private static final long[] HINT_DURATIONS;
    private static int lastHint;

    public static void onServerStarted(MinecraftServer server) {
        CleanScheduler.refreshCleanupTime();
    }

    public static void postServerTick(MinecraftServer server) {
        if (!Config.enableShipPeriodicCleanup) {
            return;
        }
        Duration timeLeft = Duration.between(Instant.now(), nextCleanup);
        if (!timeLeft.isNegative()) {
            long dur = timeLeft.getSeconds();
            for (int i = 0; i < lastHint; ++i) {
                long hint = HINT_DURATIONS[i];
                if (dur >= hint) continue;
                lastHint = i;
                server.method_3760().method_43514((class_2561)Constants.MESSAGE_PREFIX.method_27661().method_10852((class_2561)(hint > 60L ? class_2561.method_43469((String)"vsplit.message.clean.warn.min", (Object[])new Object[]{hint / 60L}) : class_2561.method_43469((String)"vsplit.message.clean.warn.sec", (Object[])new Object[]{hint}))), false);
                break;
            }
            return;
        }
        ShipCleaner.clean(server, false);
        CleanScheduler.refreshCleanupTime();
    }

    private static void refreshCleanupTime() {
        int period = Config.shipCleanPeriod;
        nextCleanup = Instant.now().plusSeconds(period);
        lastHint = HINT_DURATIONS.length;
        for (int i = 0; i < lastHint; ++i) {
            if ((long)period >= HINT_DURATIONS[i]) continue;
            lastHint = i;
            break;
        }
    }

    static {
        HINT_DURATIONS = new long[]{10L, 60L, 180L, 300L, 600L};
        lastHint = HINT_DURATIONS.length;
    }
}

