/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vsplit.impl.clean;

import com.github.litermc.vsplit.api.clean.ICleanListener;
import com.github.litermc.vsplit.config.Config;
import com.github.litermc.vsplit.config.CoreBlockBehaviour;
import com.github.litermc.vtil.api.connectivity.BlockConnectivityApi;
import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.ServerShip;

public final class ShipBlockCountCleaner
implements ICleanListener {
    public static final ShipBlockCountCleaner INSTANCE = new ShipBlockCountCleaner();

    @Override
    public int getShipCleanPriority() {
        return 10;
    }

    @Override
    public void onShipClean(ICleanListener.Context context) {
        ServerShip ship;
        if (!Config.enableBlockCountCleanup) {
            return;
        }
        if (context.getCleanSuggestion()) {
            return;
        }
        class_3218 level = context.getLevel();
        int blocks = this.getShipBlocks(level, ship = context.getShip());
        if (blocks == Integer.MAX_VALUE) {
            return;
        }
        context.setCleanSuggestion(true);
    }

    @Override
    public void checkShipCleanStatus(ICleanListener.Context context, Consumer<class_2561> messageConsumer) {
        boolean hasCore;
        ServerShip ship;
        if (!Config.enableBlockCountCleanup) {
            return;
        }
        class_3218 level = context.getLevel();
        int blocks = this.getShipBlocks(level, ship = context.getShip());
        if (blocks == Integer.MAX_VALUE) {
            return;
        }
        boolean bl = hasCore = blocks >= 0;
        if (hasCore) {
            blocks = -blocks;
        } else {
            messageConsumer.accept((class_2561)class_2561.method_43471((String)"vsplit.message.clean.core_block.hint"));
        }
        if (blocks < Config.minimumBlocksShipNeeds) {
            messageConsumer.accept((class_2561)class_2561.method_43469((String)"vsplit.message.clean.block_count.hint", (Object[])new Object[]{blocks, Config.minimumBlocksShipNeeds}));
        }
        context.setCleanSuggestion(true);
    }

    private int getShipBlocks(class_3218 level, ServerShip ship) {
        AABBic box = ship.getShipAABB();
        if (box == null) {
            return 0;
        }
        CoreBlockBehaviour behaviour = Config.coreBlockBehaviour;
        int blocks = 0;
        boolean hasCore = behaviour == CoreBlockBehaviour.IGNORED;
        for (class_2338 pos : class_2338.method_10094((int)box.minX(), (int)box.minY(), (int)box.minZ(), (int)box.maxX(), (int)box.maxY(), (int)box.maxZ())) {
            class_2680 state = level.method_8320(pos);
            if (BlockConnectivityApi.isAir((class_2680)state)) continue;
            if (!hasCore && Config.coreBlocks.contains(class_7923.field_41175.method_10221((Object)state.method_26204()))) {
                hasCore = true;
            }
            if (++blocks < Config.minimumBlocksShipNeeds || !hasCore && behaviour == CoreBlockBehaviour.REQUIRED) continue;
            return Integer.MAX_VALUE;
        }
        return hasCore ? blocks : -blocks;
    }
}

