/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vsplit.impl.clean;

import com.github.litermc.vsplit.api.clean.ICleanListener;
import com.github.litermc.vsplit.config.Config;
import com.github.litermc.vsplit.platform.PlatformHelper;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.valkyrienskies.core.api.ships.ServerShip;

public final class ShipPlayerProtectionCleaner
implements ICleanListener {
    public static final ShipPlayerProtectionCleaner INSTANCE = new ShipPlayerProtectionCleaner();

    @Override
    public int getShipCleanPriority() {
        return 10090;
    }

    @Override
    public void onShipClean(ICleanListener.Context context) {
        if (!Config.enablePlayerProtection) {
            return;
        }
        if (!context.getCleanSuggestion()) {
            return;
        }
        PlatformHelper helper = PlatformHelper.get();
        class_3218 level = context.getLevel();
        ServerShip ship = context.getShip();
        AABBdc box = ship.getWorldAABB();
        double detectRange = Config.playerProtectionRadius * 16;
        AABBd detectBox = new AABBd(box.minX() - detectRange, box.minY() - detectRange, box.minZ() - detectRange, box.maxX() + detectRange, box.maxY() + detectRange, box.maxZ() + detectRange);
        for (class_3222 player : level.method_18456()) {
            if (helper.isFakePlayer(player) || !detectBox.containsPoint(player.method_23317(), player.method_23318(), player.method_23321())) continue;
            context.setCleanSuggestion(false);
            return;
        }
    }

    @Override
    public void checkShipCleanStatus(ICleanListener.Context context, Consumer<class_2561> messageConsumer) {
    }
}

