/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vsplit.util;

import com.github.litermc.vsplit.accessor.ShipObjectServerAccessor;
import com.github.litermc.vsplit.api.attachment.ISplitListener;
import com.github.litermc.vsplit.config.Config;
import com.github.litermc.vtil.api.assemble.AssembleApi;
import com.github.litermc.vtil.api.connectivity.BlockConnectivityApi;
import com.github.litermc.vtil.util.LevelUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public final class SplitUtil {
    private static final int ASYNC_SHIP_SPLIT_TIMEOUT = 20;
    private static final Map<LoadedServerShip, Map<class_2338, OldStateHolder>> UPDATING_SHIP = new HashMap<LoadedServerShip, Map<class_2338, OldStateHolder>>();
    private static int PART_COUNTER = 0;

    private SplitUtil() {
    }

    public static void onBlockUpdated(class_3218 level, class_2338 pos, class_2680 oldState, class_2680 newState) {
        if (!Config.enableShipSplit) {
            return;
        }
        LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos((class_3218)level, (class_2382)pos);
        if (ship == null) {
            return;
        }
        Map updates = UPDATING_SHIP.computeIfAbsent(ship, s -> new HashMap());
        if (updates.containsKey(pos)) {
            return;
        }
        if (BlockConnectivityApi.isAir((class_2680)oldState)) {
            updates.put(pos, new OldStateHolder(oldState, List.of()));
        } else {
            ArrayList<class_2338> prevConns = new ArrayList<class_2338>(6);
            BlockConnectivityApi.getPossibleConnectableBlocks((class_1936)level, (class_2338)pos, (class_2680)oldState, prevConns);
            updates.put(pos, new OldStateHolder(oldState, prevConns));
        }
    }

    public static void postServerTick() {
        if (UPDATING_SHIP.isEmpty()) {
            return;
        }
        Map<LoadedServerShip, Map<class_2338, OldStateHolder>> updating = Map.copyOf(UPDATING_SHIP);
        UPDATING_SHIP.clear();
        ArrayList<ISplitListener> listeners = new ArrayList<ISplitListener>(0);
        for (Map.Entry<LoadedServerShip, Map<class_2338, OldStateHolder>> entry : updating.entrySet()) {
            ShipObjectServerAccessor slGetter0;
            LoadedServerShip ship = entry.getKey();
            AABBic shipArea = ship.getShipAABB();
            if (shipArea == null || shipArea.minX() == shipArea.maxX() && shipArea.minY() == shipArea.maxY() && shipArea.minZ() == shipArea.maxZ()) continue;
            ShipObjectServerAccessor slGetter = ship instanceof ShipObjectServerAccessor ? (slGetter0 = (ShipObjectServerAccessor)ship) : null;
            Map<class_2338, OldStateHolder> updates = entry.getValue();
            class_3218 level = LevelUtil.getLevel((String)ship.getChunkClaimDimension());
            List<Set<class_2338>> parts = SplitUtil.getSeparatedParts((class_1937)level, (Ship)ship, updates);
            if (parts == null) continue;
            String slug = SplitUtil.extractBaseSlug(ship.getSlug());
            for (Set<class_2338> part : parts) {
                ArrayList<Consumer<ServerShip>> callbacks;
                if (slGetter == null) {
                    callbacks = null;
                } else {
                    listeners.addAll(slGetter.vsplit$getSplitListeners());
                    callbacks = new ArrayList<Consumer<ServerShip>>(listeners.size());
                    SplitContext context = new SplitContext((ServerShip)ship, Collections.unmodifiableSet(part), callbacks);
                    for (ISplitListener iSplitListener : listeners) {
                        iSplitListener.onShipSplit(context);
                    }
                    listeners.clear();
                }
                if (Config.asyncShipSplit) {
                    AssembleApi.createShipAsync((class_3218)level, part, (int)20).thenAccept(splittedShip -> {
                        if (splittedShip == null) {
                            return;
                        }
                        splittedShip.setSlug(SplitUtil.addPartSlug(slug));
                        if (callbacks == null) {
                            return;
                        }
                        for (Consumer callback : callbacks) {
                            callback.accept(splittedShip);
                        }
                    });
                    continue;
                }
                ServerShip splittedShip2 = AssembleApi.createShip((class_3218)level, part);
                if (splittedShip2 == null) continue;
                splittedShip2.setSlug(SplitUtil.addPartSlug(slug));
                if (callbacks == null) continue;
                for (Consumer consumer : callbacks) {
                    consumer.accept(splittedShip2);
                }
            }
        }
    }

    private static String extractBaseSlug(String slug) {
        if (slug == null) {
            return null;
        }
        int partIndex = slug.lastIndexOf("+part-");
        if (partIndex == -1) {
            return slug;
        }
        return slug.substring(0, partIndex);
    }

    private static String addPartSlug(String slug) {
        if (slug == null) {
            return null;
        }
        if (++PART_COUNTER >= 10000) {
            PART_COUNTER = 1;
        }
        return String.format("%s+part-%04d", slug, PART_COUNTER);
    }

    public static List<Set<class_2338>> getSeparatedParts(class_1937 level, Ship ship, Map<class_2338, OldStateHolder> updates) {
        int polled;
        HashMap<class_2338, PartHolder> visited = new HashMap<class_2338, PartHolder>(32);
        HashSet<PartHolder> parts = new HashSet<PartHolder>(updates.size() * 2);
        HashSet nextPosSet = new HashSet(6);
        for (Map.Entry<class_2338, OldStateHolder> update : updates.entrySet()) {
            class_2338 startBlock = update.getKey();
            OldStateHolder prevState = update.getValue();
            class_2680 newState = level.method_8320(startBlock);
            if (!BlockConnectivityApi.willConnectivityChange((class_1936)level, (class_2338)startBlock, (class_2680)prevState.state(), (class_2680)newState)) continue;
            if (!BlockConnectivityApi.isAir((class_2680)newState)) {
                if (!visited.containsKey(startBlock)) {
                    PartHolder partHolder = new PartHolder(new Part(startBlock));
                    parts.add(partHolder);
                    visited.put(startBlock, partHolder);
                }
                BlockConnectivityApi.getPossibleConnectableBlocks((class_1936)level, (class_2338)startBlock, (class_2680)newState, nextPosSet);
            }
            if (prevState.connections().isEmpty()) {
                for (class_2338 conn : nextPosSet) {
                    if (visited.containsKey(conn) || BlockConnectivityApi.isAir((class_2680)level.method_8320(conn))) continue;
                    p = new PartHolder(new Part(conn));
                    parts.add(p);
                    visited.put(conn, p);
                }
            } else {
                for (class_2338 conn : prevState.connections()) {
                    if (nextPosSet.contains(conn) || visited.containsKey(conn) || BlockConnectivityApi.isAir((class_2680)level.method_8320(conn))) continue;
                    p = new PartHolder(new Part(conn));
                    parts.add(p);
                    visited.put(conn, p);
                }
            }
            nextPosSet.clear();
        }
        if (parts.size() <= 1) {
            return null;
        }
        ArrayList nextPoses = new ArrayList(6);
        ArrayList<Set<class_2338>> scannedParts = new ArrayList<Set<class_2338>>();
        HashSet<PartHolder> partsCopy = new HashSet<PartHolder>(parts.size());
        do {
            polled = 0;
            partsCopy.clear();
            partsCopy.addAll(parts);
            for (PartHolder partHolder : partsCopy) {
                if (!parts.contains(partHolder)) continue;
                PartHolder holder1 = partHolder.getForward();
                Part part = holder1.part;
                if (part.complete) {
                    throw new RuntimeException("unreachable");
                }
                class_2338 pos = part.poll();
                if (pos == null) {
                    part.complete = true;
                    scannedParts.add(part.blocks);
                    parts.removeIf(h -> h.getForward() == holder1);
                    continue;
                }
                ++polled;
                class_2680 state = level.method_8320(pos);
                nextPoses.clear();
                BlockConnectivityApi.getPossibleConnectableBlocks((class_1936)level, (class_2338)pos, (class_2680)state, nextPoses);
                for (class_2338 p : nextPoses) {
                    class_2680 s;
                    if (part.blocks.contains(p) || BlockConnectivityApi.isAir((class_2680)(s = level.method_8320(p))) || !BlockConnectivityApi.isBlockConnectable((class_1936)level, (class_2338)p, (class_2680)s, (class_2338)pos, (class_2680)state)) continue;
                    PartHolder otherHolder = (PartHolder)visited.get(p);
                    if (otherHolder != null) {
                        otherHolder = otherHolder.getForward();
                        Part otherPart = otherHolder.part;
                        if (otherPart == part) continue;
                        part.merge(otherPart);
                        otherPart.complete = true;
                        otherHolder.forward = partHolder;
                        parts.remove(otherHolder);
                        if (!scannedParts.isEmpty() || parts.size() > 1) continue;
                        return null;
                    }
                    part.add(p);
                    visited.put(p, partHolder);
                }
            }
        } while (polled > true);
        if (parts.isEmpty()) {
            scannedParts.remove(scannedParts.size() - 1);
        }
        return scannedParts;
    }

    public record OldStateHolder(class_2680 state, Collection<class_2338> connections) {
    }

    private static final class SplitContext
    implements ISplitListener.Context {
        private final ServerShip ship;
        private final Set<class_2338> blocks;
        private final List<Consumer<ServerShip>> callbacks;

        private SplitContext(ServerShip ship, Set<class_2338> blocks, List<Consumer<ServerShip>> callbacks) {
            this.ship = ship;
            this.blocks = blocks;
            this.callbacks = callbacks;
        }

        @Override
        public ServerShip getShip() {
            return this.ship;
        }

        @Override
        public Set<class_2338> getBlocks() {
            return this.blocks;
        }

        @Override
        public void addAfterSplit(Consumer<ServerShip> callback) {
            if (callback == null) {
                throw new IllegalArgumentException("callback cannot be null");
            }
            this.callbacks.add(callback);
        }
    }

    private static final class PartHolder {
        final Part part;
        PartHolder forward = null;

        PartHolder(Part part) {
            this.part = part;
        }

        PartHolder getForward() {
            if (this.forward != null) {
                return this.forward.getForward();
            }
            return this;
        }
    }

    private static final class Part {
        final Set<class_2338> blocks = new HashSet<class_2338>();
        final Queue<class_2338> pending = new ArrayDeque<class_2338>();
        boolean complete = false;

        Part(class_2338 startBlock) {
            this.add(startBlock);
        }

        void merge(Part other) {
            class_2338 pos;
            if (other.complete) {
                throw new RuntimeException("Unexpected early stopped scan. Connectivity inconsistent?");
            }
            this.blocks.addAll(other.blocks);
            while ((pos = other.poll()) != null) {
                this.pending.add(pos);
            }
        }

        class_2338 poll() {
            return this.pending.poll();
        }

        void add(class_2338 pos) {
            if (this.blocks.add(pos)) {
                this.pending.add(pos);
            }
        }
    }
}

