/*
 * Decompiled with CFR 0.152.
 */
package com.kyraltre.tretackshop.registry;

import com.alaharranhonor.swem.forge.blocks.BlockItemBase;
import com.alaharranhonor.swem.forge.blocks.ConeBase;
import com.alaharranhonor.swem.forge.blocks.ConeBlockItem;
import com.alaharranhonor.swem.forge.blocks.HalfBarrelBlock;
import com.alaharranhonor.swem.forge.blocks.SlowFeederBlock;
import com.alaharranhonor.swem.forge.blocks.TackBoxBlock;
import com.alaharranhonor.swem.forge.items.TackBoxBlockItem;
import com.kyraltre.tretackshop.registry.AwardShopItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class AwardShopBlockRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BLOCKS, (String)"tretackshop");
    public static final List<RegistryObject<TackBoxBlock>> AWARD_TACK_BOX;
    public static final List<RegistryObject<TackBoxBlock>> TACK_BOX_HOUND;
    public static final List<RegistryObject<TackBoxBlock>> TACK_BOX_MORPHO;
    public static final List<RegistryObject<TackBoxBlock>> TACK_BOX_MONARCH;
    public static final List<RegistryObject<HalfBarrelBlock>> HALF_BARREL_MONARCH;
    public static final List<RegistryObject<HalfBarrelBlock>> HALF_BARREL_MORPHO;
    public static final List<RegistryObject<HalfBarrelBlock>> HALF_BARREL_HOUND;
    public static final List<RegistryObject<SlowFeederBlock>> SLOW_FEEDER_MONARCH;
    public static final List<RegistryObject<SlowFeederBlock>> SLOW_FEEDER_MORPHO;
    public static final List<RegistryObject<SlowFeederBlock>> SLOW_FEEDER_HOUND;
    public static final List<RegistryObject<Block>> CONE_MORPHO;
    public static final List<RegistryObject<Block>> CONE_MONARCH;
    public static final List<RegistryObject<Block>> CONE_HOUND;

    public static void init(IEventBus modBus) {
        BLOCKS.register(modBus);
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup) {
        return AwardShopBlockRegistry.register(name, sup);
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup, Function<RegistryObject<T>, Supplier<? extends Item>> itemCreator) {
        RegistryObject<? extends T> ret = AwardShopBlockRegistry.registerNoItem(name, sup);
        AwardShopItems.REGISTRY.register(name, itemCreator.apply(ret));
        return ret;
    }

    private static <T extends Block> RegistryObject<T> registerNoItem(String name, Supplier<? extends T> sup) {
        return BLOCKS.register(name, sup);
    }

    private static Supplier<BlockItem> item(RegistryObject<? extends Block> block, CreativeModeTab itemGroup) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties());
    }

    static {
        CONE_MONARCH = new ArrayList<RegistryObject<Block>>();
        CONE_MORPHO = new ArrayList<RegistryObject<Block>>();
        CONE_HOUND = new ArrayList<RegistryObject<Block>>();
        AWARD_TACK_BOX = new ArrayList<RegistryObject<TackBoxBlock>>();
        TACK_BOX_MONARCH = new ArrayList<RegistryObject<TackBoxBlock>>();
        TACK_BOX_MORPHO = new ArrayList<RegistryObject<TackBoxBlock>>();
        TACK_BOX_HOUND = new ArrayList<RegistryObject<TackBoxBlock>>();
        HALF_BARREL_MONARCH = new ArrayList<RegistryObject<HalfBarrelBlock>>();
        HALF_BARREL_MORPHO = new ArrayList<RegistryObject<HalfBarrelBlock>>();
        HALF_BARREL_HOUND = new ArrayList<RegistryObject<HalfBarrelBlock>>();
        SLOW_FEEDER_MONARCH = new ArrayList<RegistryObject<SlowFeederBlock>>();
        SLOW_FEEDER_MORPHO = new ArrayList<RegistryObject<SlowFeederBlock>>();
        SLOW_FEEDER_HOUND = new ArrayList<RegistryObject<SlowFeederBlock>>();
        for (int var8 = 1; var8 < 2; ++var8) {
            CONE_MORPHO.add(AwardShopBlockRegistry.register("cone_morpho", () -> new ConeBase(), block -> () -> new ConeBlockItem((Block)block.get())));
            CONE_MONARCH.add(AwardShopBlockRegistry.register("cone_monarch", () -> new ConeBase(), block -> () -> new ConeBlockItem((Block)block.get())));
            CONE_HOUND.add(AwardShopBlockRegistry.register("cone_hound", () -> new ConeBase(), block -> () -> new ConeBlockItem((Block)block.get())));
            TACK_BOX_MORPHO.add(AwardShopBlockRegistry.register("tack_box_morpho", () -> new TackBoxBlock(BlockBehaviour.Properties.m_284310_().m_60955_().m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f), 1), block -> () -> new TackBoxBlockItem((Block)block.get())));
            TACK_BOX_MONARCH.add(AwardShopBlockRegistry.register("tack_box_monarch", () -> new TackBoxBlock(BlockBehaviour.Properties.m_284310_().m_60955_().m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f), 1), block -> () -> new TackBoxBlockItem((Block)block.get())));
            TACK_BOX_HOUND.add(AwardShopBlockRegistry.register("tack_box_hound", () -> new TackBoxBlock(BlockBehaviour.Properties.m_284310_().m_60955_().m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f), 1), block -> () -> new TackBoxBlockItem((Block)block.get())));
            HALF_BARREL_MONARCH.add(AwardShopBlockRegistry.register("half_barrel_monarch", () -> new HalfBarrelBlock(BlockBehaviour.Properties.m_284310_().m_60955_().m_60918_(SoundType.f_56743_).m_60913_(2.0f, 3.0f)), block -> () -> new BlockItemBase((Block)block.get())));
            HALF_BARREL_MORPHO.add(AwardShopBlockRegistry.register("half_barrel_morpho", () -> new HalfBarrelBlock(BlockBehaviour.Properties.m_284310_().m_60955_().m_60918_(SoundType.f_56743_).m_60913_(2.0f, 3.0f)), block -> () -> new BlockItemBase((Block)block.get())));
            HALF_BARREL_HOUND.add(AwardShopBlockRegistry.register("half_barrel_hound", () -> new HalfBarrelBlock(BlockBehaviour.Properties.m_284310_().m_60955_().m_60918_(SoundType.f_56743_).m_60913_(2.0f, 3.0f)), block -> () -> new BlockItemBase((Block)block.get())));
            SLOW_FEEDER_MONARCH.add(AwardShopBlockRegistry.register("slow_feeder_monarch", () -> new SlowFeederBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60913_(3.0f, 4.0f), null), block -> () -> new BlockItemBase((Block)block.get())));
            SLOW_FEEDER_MORPHO.add(AwardShopBlockRegistry.register("slow_feeder_morpho", () -> new SlowFeederBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60913_(3.0f, 4.0f), null), block -> () -> new BlockItemBase((Block)block.get())));
            SLOW_FEEDER_HOUND.add(AwardShopBlockRegistry.register("slow_feeder_hound", () -> new SlowFeederBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60913_(3.0f, 4.0f), null), block -> () -> new BlockItemBase((Block)block.get())));
        }
        for (int var4 = 0; var4 < 14; ++var4) {
            int counter = var4 + 1;
            AWARD_TACK_BOX.add(AwardShopBlockRegistry.register("award_tack_box_" + counter, () -> new TackBoxBlock(BlockBehaviour.Properties.m_284310_().m_60955_().m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f), 1), block -> () -> new TackBoxBlockItem((Block)block.get())));
        }
    }
}

