/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.client.core.context;

import com.google.common.collect.ImmutableMap;
import fuzs.puzzleslib.api.client.core.v1.context.GuiLayersContext;
import fuzs.puzzleslib.api.client.gui.v2.GuiHeightHelper;
import fuzs.puzzleslib.api.event.v1.core.EventPhase;
import fuzs.puzzleslib.fabric.impl.event.FabricEventInvokerRegistryImpl;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.fabricmc.fabric.api.client.rendering.v1.HudLayerRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.IdentifiedLayer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_9080;
import net.minecraft.class_9779;

public final class GuiLayersContextFabricImpl
implements GuiLayersContext {
    private static final Map<class_2960, class_2960> VANILLA_GUI_LAYERS = ImmutableMap.builder().put((Object)CAMERA_OVERLAYS, (Object)IdentifiedLayer.MISC_OVERLAYS).put((Object)CROSSHAIR, (Object)IdentifiedLayer.CROSSHAIR).put((Object)HOTBAR, (Object)IdentifiedLayer.HOTBAR_AND_BARS).put((Object)JUMP_METER, (Object)IdentifiedLayer.HOTBAR_AND_BARS).put((Object)EXPERIENCE_BAR, (Object)IdentifiedLayer.HOTBAR_AND_BARS).put((Object)PLAYER_HEALTH, (Object)IdentifiedLayer.HOTBAR_AND_BARS).put((Object)ARMOR_LEVEL, (Object)IdentifiedLayer.HOTBAR_AND_BARS).put((Object)FOOD_LEVEL, (Object)IdentifiedLayer.HOTBAR_AND_BARS).put((Object)VEHICLE_HEALTH, (Object)IdentifiedLayer.HOTBAR_AND_BARS).put((Object)AIR_LEVEL, (Object)IdentifiedLayer.HOTBAR_AND_BARS).put((Object)SELECTED_ITEM_NAME, (Object)IdentifiedLayer.HOTBAR_AND_BARS).put((Object)EXPERIENCE_LEVEL, (Object)IdentifiedLayer.EXPERIENCE_LEVEL).put((Object)STATUS_EFFECTS, (Object)IdentifiedLayer.STATUS_EFFECTS).put((Object)BOSS_BAR, (Object)IdentifiedLayer.BOSS_BAR).put((Object)SLEEP_OVERLAY, (Object)IdentifiedLayer.SLEEP).put((Object)DEMO_TIMER, (Object)IdentifiedLayer.DEMO_TIMER).put((Object)DEBUG_OVERLAY, (Object)IdentifiedLayer.DEBUG).put((Object)SCOREBOARD, (Object)IdentifiedLayer.SCOREBOARD).put((Object)OVERLAY_MESSAGE, (Object)IdentifiedLayer.OVERLAY_MESSAGE).put((Object)TITLE, (Object)IdentifiedLayer.TITLE_AND_SUBTITLE).put((Object)CHAT, (Object)IdentifiedLayer.CHAT).put((Object)PLAYER_LIST, (Object)IdentifiedLayer.PLAYER_LIST).put((Object)SUBTITLES, (Object)IdentifiedLayer.SUBTITLES).build();
    public static final Map<class_2960, UnaryOperator<class_9080.class_9081>> REPLACED_GUI_LAYERS = new IdentityHashMap<class_2960, UnaryOperator<class_9080.class_9081>>();
    private class_2960 eventPhase = EventPhase.DEFAULT.resourceLocation();

    @Override
    public void setEventPhase(EventPhase eventPhase) {
        Objects.requireNonNull(eventPhase, "event phase is null");
        FabricEventInvokerRegistryImpl.registerEventPhaseIfNecessary(HudLayerRegistrationCallback.EVENT, eventPhase);
        this.eventPhase = eventPhase.resourceLocation();
    }

    @Override
    public void registerGuiLayer(class_2960 resourceLocation, class_9080.class_9081 guiLayer) {
        Objects.requireNonNull(resourceLocation, "resource location is null");
        Objects.requireNonNull(guiLayer, "gui layer is null");
        HudLayerRegistrationCallback.EVENT.register(this.eventPhase, layeredDrawerWrapper -> layeredDrawerWrapper.addLayer(IdentifiedLayer.of((class_2960)resourceLocation, (class_9080.class_9081)guiLayer)));
    }

    @Override
    public void registerGuiLayer(class_2960 resourceLocation, class_2960 otherResourceLocation, class_9080.class_9081 guiLayer) {
        Objects.requireNonNull(resourceLocation, "resource location is null");
        Objects.requireNonNull(otherResourceLocation, "other resource location is null");
        Objects.requireNonNull(guiLayer, "gui layer is null");
        if (VANILLA_GUI_LAYERS.containsKey(resourceLocation)) {
            class_2960 vanillaResourceLocation = VANILLA_GUI_LAYERS.get(resourceLocation);
            HudLayerRegistrationCallback.EVENT.register(this.eventPhase, layeredDrawerWrapper -> layeredDrawerWrapper.attachLayerAfter(vanillaResourceLocation, otherResourceLocation, guiLayer));
        } else if (VANILLA_GUI_LAYERS.containsKey(otherResourceLocation)) {
            class_2960 vanillaResourceLocation = VANILLA_GUI_LAYERS.get(otherResourceLocation);
            HudLayerRegistrationCallback.EVENT.register(this.eventPhase, layeredDrawerWrapper -> layeredDrawerWrapper.attachLayerBefore(vanillaResourceLocation, resourceLocation, guiLayer));
        } else {
            throw new RuntimeException("Unregistered gui layers: " + String.valueOf(resourceLocation) + ", " + String.valueOf(otherResourceLocation));
        }
    }

    @Override
    public void replaceGuiLayer(class_2960 resourceLocation, UnaryOperator<class_9080.class_9081> guiLayerFactory) {
        Objects.requireNonNull(resourceLocation, "resource location is null");
        Objects.requireNonNull(guiLayerFactory, "gui layer factory is null");
        if (VANILLA_GUI_LAYERS.containsKey(resourceLocation)) {
            class_2960 vanillaResourceLocation = VANILLA_GUI_LAYERS.get(resourceLocation);
            if (vanillaResourceLocation != IdentifiedLayer.HOTBAR_AND_BARS) {
                HudLayerRegistrationCallback.EVENT.register(this.eventPhase, layeredDrawerWrapper -> layeredDrawerWrapper.replaceLayer(vanillaResourceLocation, identifiedLayer -> IdentifiedLayer.of((class_2960)identifiedLayer.id(), (class_9080.class_9081)((class_9080.class_9081)guiLayerFactory.apply((class_9080.class_9081)identifiedLayer)))));
            } else {
                REPLACED_GUI_LAYERS.merge(resourceLocation, guiLayerFactory, (originalGuiLayerFactory, newGuiLayerFactory) -> layer -> (class_9080.class_9081)newGuiLayerFactory.apply((class_9080.class_9081)originalGuiLayerFactory.apply(layer)));
            }
        } else {
            throw new RuntimeException("Unregistered gui layer: " + String.valueOf(resourceLocation));
        }
    }

    public static void renderGuiLayer(class_2960 resourceLocation, class_332 guiGraphics, class_9779 deltaTracker, Runnable runnable) {
        UnaryOperator<class_9080.class_9081> unaryOperator = REPLACED_GUI_LAYERS.get(resourceLocation);
        if (unaryOperator != null) {
            ((class_9080.class_9081)unaryOperator.apply((guiGraphicsX, deltaTrackerX) -> runnable.run())).render(guiGraphics, deltaTracker);
        } else {
            runnable.run();
        }
    }

    public static void applyPlayerHealthGuiHeight(class_329 gui) {
        class_1297 class_12972;
        if (gui.field_2035.field_1761.method_2908() && (class_12972 = gui.field_2035.method_1560()) instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            int playerHealth = class_3532.method_15386((float)player.method_6032());
            float maxHealth = Math.max((float)player.method_45325(class_5134.field_23716), (float)Math.max(gui.field_2033, playerHealth));
            int absorptionAmount = class_3532.method_15386((float)player.method_6067());
            int healthRows = class_3532.method_15386((float)((maxHealth + (float)absorptionAmount) / 2.0f / 10.0f));
            int healthRowShift = Math.max(10 - (healthRows - 2), 3);
            GuiHeightHelper.addLeftHeight(gui, 10 + (healthRows - 1) * healthRowShift);
        }
    }

    public static void applyArmorLevelGuiHeight(class_329 gui) {
        class_1657 player;
        class_1297 class_12972;
        if (gui.field_2035.field_1761.method_2908() && (class_12972 = gui.field_2035.method_1560()) instanceof class_1657 && (player = (class_1657)class_12972).method_6096() > 0) {
            GuiHeightHelper.addLeftHeight(gui, 10);
        }
    }

    public static void applyFoodLevelGuiHeight(class_329 gui) {
        class_1309 livingEntity;
        if (gui.field_2035.field_1761.method_2908() && gui.field_2035.method_1560() instanceof class_1657 && gui.method_1744(livingEntity = gui.method_1734()) == 0) {
            GuiHeightHelper.addRightHeight(gui, 10);
        }
    }

    public static void applyAirLevelGuiHeight(class_329 gui) {
        class_1297 class_12972;
        if (gui.field_2035.field_1761.method_2908() && (class_12972 = gui.field_2035.method_1560()) instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            int maxAirSupply = player.method_5748();
            int airSupply = Math.min(player.method_5669(), maxAirSupply);
            if (player.method_5777(class_3486.field_15517) || airSupply < maxAirSupply) {
                GuiHeightHelper.addRightHeight(gui, 10);
            }
        }
    }

    public static void applyVehicleHealthGuiHeight(class_329 gui) {
        if (gui.field_2035.method_1560() instanceof class_1657) {
            class_1309 livingEntity = gui.method_1734();
            int maxHearts = gui.method_1744(livingEntity);
            GuiHeightHelper.addRightHeight(gui, 10 * class_3532.method_15386((float)((float)maxHearts / 10.0f)));
        }
    }
}

