/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.attachment.builder;

import fuzs.puzzleslib.api.attachment.v4.DataAttachmentRegistry;
import fuzs.puzzleslib.api.event.v1.entity.player.AfterChangeDimensionCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerCopyEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerNetworkEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTrackingEvents;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.PlayerSet;
import fuzs.puzzleslib.impl.attachment.AttachmentTypeAdapter;
import fuzs.puzzleslib.impl.attachment.ClientboundEntityDataAttachmentMessage;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public interface EntityDataAttachmentBuilder<V>
extends DataAttachmentRegistry.EntityBuilder<V> {
    @Nullable
    default public BiConsumer<class_1297, V> getSynchronizer(AttachmentTypeAdapter<class_1297, V> attachmentType, @Nullable class_9139<? super class_9129, V> streamCodec, @Nullable Function<class_1297, PlayerSet> synchronizationTargets) {
        if (streamCodec == null) {
            return null;
        }
        class_8710.class_9154 payloadType = new class_8710.class_9154(attachmentType.resourceLocation());
        this.registerPayloadHandlers(attachmentType, payloadType, streamCodec);
        this.registerEventHandlers(attachmentType, payloadType, synchronizationTargets);
        return this.getDefaultSynchronizer(attachmentType, payloadType, synchronizationTargets);
    }

    public void registerPayloadHandlers(AttachmentTypeAdapter<class_1297, V> var1, class_8710.class_9154<ClientboundEntityDataAttachmentMessage<V>> var2, @Nullable class_9139<? super class_9129, V> var3);

    private void registerEventHandlers(AttachmentTypeAdapter<class_1297, V> attachmentType, class_8710.class_9154<ClientboundEntityDataAttachmentMessage<V>> payloadType, @Nullable Function<class_1297, PlayerSet> synchronizationTargets) {
        PlayerNetworkEvents.LOGGED_IN.register(serverPlayer -> this.broadcast(attachmentType, payloadType, serverPlayer));
        AfterChangeDimensionCallback.EVENT.register((serverPlayer, from, to) -> this.broadcast(attachmentType, payloadType, serverPlayer));
        PlayerCopyEvents.RESPAWN.register((serverPlayer, originalStillAlive) -> this.broadcast(attachmentType, payloadType, serverPlayer));
        if (synchronizationTargets != null) {
            PlayerTrackingEvents.START.register((trackedEntity, serverPlayer) -> this.broadcast(attachmentType, payloadType, trackedEntity, PlayerSet.ofPlayer(serverPlayer)));
        }
    }

    private BiConsumer<class_1297, V> getDefaultSynchronizer(AttachmentTypeAdapter<class_1297, V> attachmentType, class_8710.class_9154<ClientboundEntityDataAttachmentMessage<V>> payloadType, @Nullable Function<class_1297, PlayerSet> synchronizationTargets) {
        return (entity, value) -> {
            PlayerSet playerSet = synchronizationTargets != null ? (PlayerSet)synchronizationTargets.apply((class_1297)entity) : PlayerSet.ofEntity(entity);
            this.broadcast(attachmentType, payloadType, (class_1297)entity, playerSet, (V)value);
        };
    }

    private void broadcast(AttachmentTypeAdapter<class_1297, V> attachmentType, class_8710.class_9154<ClientboundEntityDataAttachmentMessage<V>> payloadType, class_3222 serverPlayer) {
        this.broadcast(attachmentType, payloadType, (class_1297)serverPlayer, PlayerSet.ofPlayer(serverPlayer));
    }

    private void broadcast(AttachmentTypeAdapter<class_1297, V> attachmentType, class_8710.class_9154<ClientboundEntityDataAttachmentMessage<V>> payloadType, class_1297 entity, PlayerSet playerSet) {
        if (attachmentType.hasData(entity)) {
            this.broadcast(attachmentType, payloadType, entity, playerSet, attachmentType.getData(entity));
        }
    }

    private void broadcast(AttachmentTypeAdapter<class_1297, V> attachmentType, class_8710.class_9154<ClientboundEntityDataAttachmentMessage<V>> payloadType, class_1297 entity, PlayerSet playerSet, @Nullable V value) {
        ClientboundEntityDataAttachmentMessage<V> message = new ClientboundEntityDataAttachmentMessage<V>(attachmentType, payloadType, entity.method_5628(), Optional.ofNullable(value));
        MessageSender.broadcast(playerSet, message);
    }
}

