/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.event;

import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.fabric.impl.core.FabricProxy;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2824;
import net.minecraft.class_2828;
import net.minecraft.class_2885;
import net.minecraft.class_2886;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public interface FabricPlayerInteraction {
    public static final FabricPlayerInteraction USE_BLOCK = new FabricPlayerInteraction(){

        @Override
        public boolean sendServerboundPacket(class_1269 interactionResult) {
            return interactionResult != class_1269.field_5812;
        }

        @Override
        public void sendServerboundPacket(class_1657 player, class_1937 level, class_1268 interactionHand, @Nullable class_1297 entity, @Nullable class_239 hitResult) {
            Objects.requireNonNull(hitResult, "hit result is null");
            FabricProxy.get().startClientPrediction(level, id -> new class_2885(interactionHand, (class_3965)hitResult, id));
        }
    };
    public static final FabricPlayerInteraction USE_ITEM = new FabricPlayerInteraction(){

        @Override
        public boolean sendServerboundPacket(class_1269 interactionResult) {
            return interactionResult != class_1269.field_5812;
        }

        @Override
        public void sendServerboundPacket(class_1657 player, class_1937 level, class_1268 interactionHand, @Nullable class_1297 entity, @Nullable class_239 hitResult) {
            MessageSender.broadcast(new class_2828.class_2830(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455(), player.method_24828(), player.field_5976));
            FabricProxy.get().startClientPrediction(level, id -> new class_2886(interactionHand, id, player.method_36454(), player.method_36455()));
        }
    };
    public static final FabricPlayerInteraction USE_ENTITY = new FabricPlayerInteraction(){

        @Override
        public boolean sendServerboundPacket(class_1269 interactionResult) {
            return true;
        }

        @Override
        public void sendServerboundPacket(class_1657 player, class_1937 level, class_1268 interactionHand, @Nullable class_1297 entity, @Nullable class_239 hitResult) {
            Objects.requireNonNull(entity, "entity is null");
            MessageSender.broadcast(class_2824.method_34207((class_1297)entity, (boolean)player.method_5715(), (class_1268)interactionHand));
        }

        @Override
        public class_1269 finalizeInteraction(class_1269 interactionResult, class_1657 player, class_1268 interactionHand) {
            class_1269.class_9860 success;
            if (interactionResult instanceof class_1269.class_9860 && (success = (class_1269.class_9860)interactionResult).comp_2909() == class_1269.class_9861.field_52427) {
                player.method_6104(interactionHand);
            }
            return class_1269.field_5814;
        }
    };
    public static final FabricPlayerInteraction USE_ENTITY_AT = new FabricPlayerInteraction(){

        @Override
        public boolean sendServerboundPacket(class_1269 interactionResult) {
            return !interactionResult.method_23665();
        }

        @Override
        public void sendServerboundPacket(class_1657 player, class_1937 level, class_1268 interactionHand, @Nullable class_1297 entity, @Nullable class_239 hitResult) {
            Objects.requireNonNull(entity, "entity is null");
            Objects.requireNonNull(hitResult, "hit result is null");
            MessageSender.broadcast(class_2824.method_34208((class_1297)entity, (boolean)player.method_5715(), (class_1268)interactionHand, (class_243)hitResult.method_17784()));
        }
    };

    default public class_1269 getHandledInteractionResult(EventResultHolder<class_1269> eventResult, class_1657 player, class_1937 level, class_1268 interactionHand, @Nullable class_1297 entity, @Nullable class_239 hitResult) {
        Optional<class_1269> optional = eventResult.getInterrupt();
        if (optional.isPresent()) {
            class_1269 interactionResult = optional.get();
            if (level.method_8608() && this.sendServerboundPacket(interactionResult)) {
                this.sendServerboundPacket(player, level, interactionHand, entity, hitResult);
            }
            return this.finalizeInteraction(interactionResult, player, interactionHand);
        }
        return class_1269.field_5811;
    }

    public boolean sendServerboundPacket(class_1269 var1);

    public void sendServerboundPacket(class_1657 var1, class_1937 var2, class_1268 var3, @Nullable class_1297 var4, @Nullable class_239 var5);

    default public class_1269 finalizeInteraction(class_1269 interactionResult, class_1657 player, class_1268 interactionHand) {
        return interactionResult != class_1269.field_5811 ? interactionResult : class_1269.field_5814;
    }
}

