/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.renderer.v1;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.ChestModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.renderer.blockentity.state.ChestRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public abstract class SingleChestRenderer<T extends BlockEntity, M extends ChestModel, S extends SingleChestRenderState>
extends ChestRenderer<T> {
    protected final MaterialSet materials;
    protected final M chestModel;

    public SingleChestRenderer(BlockEntityRendererProvider.Context context, M chestModel) {
        super(context);
        this.materials = context.materials();
        this.chestModel = chestModel;
    }

    public S createRenderState() {
        return (S)((Object)new SingleChestRenderState());
    }

    public void extractRenderState(T blockEntity, ChestRenderState chestRenderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(blockEntity, chestRenderState, partialTick, cameraPosition, crumblingOverlay);
        ((SingleChestRenderState)chestRenderState).chestMaterial = this.getChestMaterial(blockEntity, this.xmasTextures);
    }

    public void submit(ChestRenderState chestRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-chestRenderState.angle));
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        this.submitChestModel((SingleChestRenderState)chestRenderState, poseStack, submitNodeCollector);
        poseStack.popPose();
    }

    protected void submitChestModel(S chestRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector) {
        Material material = ((SingleChestRenderState)((Object)chestRenderState)).chestMaterial;
        RenderType renderType = material.renderType(RenderType::entityCutout);
        TextureAtlasSprite textureAtlasSprite = this.materials.get(material);
        submitNodeCollector.submitModel(this.chestModel, (Object)Float.valueOf(((SingleChestRenderState)((Object)chestRenderState)).getOpenness()), poseStack, renderType, ((SingleChestRenderState)((Object)chestRenderState)).lightCoords, OverlayTexture.NO_OVERLAY, -1, textureAtlasSprite, 0, ((SingleChestRenderState)((Object)chestRenderState)).breakProgress);
    }

    protected abstract Material getChestMaterial(T var1, boolean var2);

    public static class SingleChestRenderState
    extends ChestRenderState {
        public Material chestMaterial = Sheets.CHEST_LOCATION;

        public float getOpenness() {
            float openness = this.open;
            openness = 1.0f - openness;
            return 1.0f - openness * openness * openness;
        }
    }
}

