/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.config.v3.serialization;

import fuzs.puzzleslib.api.data.v2.tags.AbstractTagAppender;
import fuzs.puzzleslib.api.data.v2.tags.AbstractTagProvider;
import fuzs.puzzleslib.impl.config.serialization.RegistryProvider;
import fuzs.puzzleslib.impl.data.SortingTagBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public interface KeyedValueProvider<T> {
    public static <T> KeyedValueProvider<T> registryEntries(ResourceKey<? extends Registry<? super T>> registryKey) {
        return new RegistryProvider(registryKey);
    }

    public static <T> AbstractTagAppender<T> tagAppender(ResourceKey<? extends Registry<? super T>> registryKey) {
        return AbstractTagProvider.createTagAppender(new SortingTagBuilder(), registryKey);
    }

    @SafeVarargs
    public static <T> List<String> asString(ResourceKey<? extends Registry<? super T>> registryKey, T ... entries) {
        return KeyedValueProvider.asString(KeyedValueProvider.registryEntries(registryKey), entries);
    }

    @SafeVarargs
    public static <T> List<String> asString(KeyedValueProvider<T> valueProvider, T ... entries) {
        return Stream.of(entries).peek(Objects::requireNonNull).map(valueProvider::getKey).filter(Objects::nonNull).map(ResourceLocation::toString).collect(Collectors.toList());
    }

    public Optional<T> getValue(ResourceLocation var1);

    public ResourceLocation getKey(T var1);

    public Stream<Map.Entry<ResourceLocation, T>> stream();

    public Stream<T> streamValues();

    public String name();
}

