/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.container.v1;

import fuzs.puzzleslib.api.container.v1.SimpleContainerImpl;
import net.minecraft.core.NonNullList;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

@FunctionalInterface
public interface ListBackedContainer
extends SimpleContainerImpl {
    public static ListBackedContainer of(NonNullList<ItemStack> items) {
        return () -> items;
    }

    public static ListBackedContainer of(int size) {
        return ListBackedContainer.of((NonNullList<ItemStack>)NonNullList.withSize((int)size, (Object)ItemStack.EMPTY));
    }

    public NonNullList<ItemStack> getContainerItems();

    default public int getContainerSize() {
        return this.getContainerItems().size();
    }

    default public void setChanged() {
    }

    default public boolean stillValid(Player player) {
        return true;
    }

    @Override
    default public ItemStack getContainerItem(int slot) {
        return (ItemStack)this.getContainerItems().get(slot);
    }

    @Override
    default public ItemStack removeContainerItem(int slot, int amount) {
        return ContainerHelper.removeItem(this.getContainerItems(), (int)slot, (int)amount);
    }

    @Override
    default public ItemStack removeContainerItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.getContainerItems(), (int)slot);
    }

    @Override
    default public void setContainerItem(int slot, ItemStack itemStack) {
        this.getContainerItems().set(slot, (Object)itemStack);
    }
}

